package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class PodChaosSpecFluentImpl<A extends PodChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodChaosSpecFluent<A> {

    private String action;
    private String containerName;
    private String duration;
    private Long gracePeriod;
    private String mode;
    private SchedulerSpecBuilder scheduler;
    private SelectorSpecBuilder selector;
    private String value;

    public PodChaosSpecFluentImpl() {
    }

    public PodChaosSpecFluentImpl(PodChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withContainerName(instance.getContainerName()); 
        this.withDuration(instance.getDuration()); 
        this.withGracePeriod(instance.getGracePeriod()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    public String getContainerName() {
        return this.containerName;
    }

    public A withContainerName(String containerName) {
        this.containerName=containerName; return (A) this;
    }

    public Boolean hasContainerName() {
        return this.containerName != null;
    }

    public A withNewContainerName(String arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public A withNewContainerName(StringBuilder arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public A withNewContainerName(StringBuffer arg1) {
        return (A)withContainerName(new String(arg1));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public Long getGracePeriod() {
        return this.gracePeriod;
    }

    public A withGracePeriod(Long gracePeriod) {
        this.gracePeriod=gracePeriod; return (A) this;
    }

    public Boolean hasGracePeriod() {
        return this.gracePeriod != null;
    }

    public A withNewGracePeriod(String arg1) {
        return (A)withGracePeriod(new Long(arg1));
    }

    public A withNewGracePeriod(long arg1) {
        return (A)withGracePeriod(new Long(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public PodChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public PodChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public PodChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public PodChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public PodChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public PodChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public PodChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public PodChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public PodChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public PodChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodChaosSpecFluentImpl that = (PodChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (containerName != null ? !containerName.equals(that.containerName) :that.containerName != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (gracePeriod != null ? !gracePeriod.equals(that.gracePeriod) :that.gracePeriod != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  containerName,  duration,  gracePeriod,  mode,  scheduler,  selector,  value,  super.hashCode());
    }

    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<PodChaosSpecFluent.SchedulerNested<N>> implements PodChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PodChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<PodChaosSpecFluent.SelectorNested<N>> implements PodChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) PodChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
