package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JVMExceptionSpecBuilder extends JVMExceptionSpecFluentImpl<JVMExceptionSpecBuilder> implements VisitableBuilder<JVMExceptionSpec,JVMExceptionSpecBuilder> {

    JVMExceptionSpecFluent<?> fluent;
    Boolean validationEnabled;

    public JVMExceptionSpecBuilder() {
        this(true);
    }

    public JVMExceptionSpecBuilder(Boolean validationEnabled) {
        this(new JVMExceptionSpec(), validationEnabled);
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new JVMExceptionSpec(), validationEnabled);
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,JVMExceptionSpec instance) {
        this(fluent, instance, true);
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpecFluent<?> fluent,JVMExceptionSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAfter(instance.getAfter()); 
        fluent.withClassname(instance.getClassname()); 
        fluent.withException(instance.getException()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withMethodname(instance.getMethodname()); 
        this.validationEnabled = validationEnabled; 
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpec instance) {
        this(instance,true);
    }

    public JVMExceptionSpecBuilder(JVMExceptionSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAfter(instance.getAfter()); 
        this.withClassname(instance.getClassname()); 
        this.withException(instance.getException()); 
        this.withMessage(instance.getMessage()); 
        this.withMethodname(instance.getMethodname()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableJVMExceptionSpec build() {
        EditableJVMExceptionSpec buildable = new EditableJVMExceptionSpec(fluent.isAfter(),fluent.getClassname(),fluent.getException(),fluent.getMessage(),fluent.getMethodname());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JVMExceptionSpecBuilder that = (JVMExceptionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
