package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import java.lang.Integer;
import java.lang.StringBuffer;

public class JVMChaosSpecFluentImpl<A extends JVMChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements JVMChaosSpecFluent<A> {

    private String action;
    private JVMCpufullloadSpecBuilder cfl;
    private JVMDelaySpecBuilder delay;
    private ServletDelaySpecBuilder delay4servlet;
    private String duration;
    private Integer effectcount;
    private Integer effectpercent;
    private String mode;
    private JVMOOMSpecBuilder oom;
    private JVMReturnSpecBuilder _return;
    private SchedulerSpecBuilder scheduler;
    private JVMScriptSpecBuilder script;
    private SelectorSpecBuilder selector;
    private JVMExceptionSpecBuilder tce;
    private ServletExceptionSpecBuilder tce4servlet;
    private String value;

    public JVMChaosSpecFluentImpl() {
    }

    public JVMChaosSpecFluentImpl(JVMChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withCfl(instance.getCfl()); 
        this.withDelay(instance.getDelay()); 
        this.withDelay4servlet(instance.getDelay4servlet()); 
        this.withDuration(instance.getDuration()); 
        this.withEffectcount(instance.getEffectcount()); 
        this.withEffectpercent(instance.getEffectpercent()); 
        this.withMode(instance.getMode()); 
        this.withOom(instance.getOom()); 
        this.withReturn(instance.getReturn()); 
        this.withScheduler(instance.getScheduler()); 
        this.withScript(instance.getScript()); 
        this.withSelector(instance.getSelector()); 
        this.withTce(instance.getTce()); 
        this.withTce4servlet(instance.getTce4servlet()); 
        this.withValue(instance.getValue()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCfl instead.
 * @return The buildable object.
 */
@Deprecated public JVMCpufullloadSpec getCfl() {
        return this.cfl!=null?this.cfl.build():null;
    }

    public JVMCpufullloadSpec buildCfl() {
        return this.cfl!=null?this.cfl.build():null;
    }

    public A withCfl(JVMCpufullloadSpec cfl) {
        _visitables.get("cfl").remove(this.cfl);
        if (cfl!=null){ this.cfl= new JVMCpufullloadSpecBuilder(cfl); _visitables.get("cfl").add(this.cfl);} return (A) this;
    }

    public Boolean hasCfl() {
        return this.cfl != null;
    }

    public A withNewCfl(Boolean after,String classname,Integer cpucount,String methodname) {
        return (A)withCfl(new JVMCpufullloadSpec(after, classname, cpucount, methodname));
    }

    public JVMChaosSpecFluent.CflNested<A> withNewCfl() {
        return new CflNestedImpl();
    }

    public JVMChaosSpecFluent.CflNested<A> withNewCflLike(JVMCpufullloadSpec item) {
        return new CflNestedImpl(item);
    }

    public JVMChaosSpecFluent.CflNested<A> editCfl() {
        return withNewCflLike(getCfl());
    }

    public JVMChaosSpecFluent.CflNested<A> editOrNewCfl() {
        return withNewCflLike(getCfl() != null ? getCfl(): new JVMCpufullloadSpecBuilder().build());
    }

    public JVMChaosSpecFluent.CflNested<A> editOrNewCflLike(JVMCpufullloadSpec item) {
        return withNewCflLike(getCfl() != null ? getCfl(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelay instead.
 * @return The buildable object.
 */
@Deprecated public JVMDelaySpec getDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public JVMDelaySpec buildDelay() {
        return this.delay!=null?this.delay.build():null;
    }

    public A withDelay(JVMDelaySpec delay) {
        _visitables.get("delay").remove(this.delay);
        if (delay!=null){ this.delay= new JVMDelaySpecBuilder(delay); _visitables.get("delay").add(this.delay);} return (A) this;
    }

    public Boolean hasDelay() {
        return this.delay != null;
    }

    public A withNewDelay(Boolean after,String classname,String methodname,Integer offset,Integer time) {
        return (A)withDelay(new JVMDelaySpec(after, classname, methodname, offset, time));
    }

    public JVMChaosSpecFluent.DelayNested<A> withNewDelay() {
        return new DelayNestedImpl();
    }

    public JVMChaosSpecFluent.DelayNested<A> withNewDelayLike(JVMDelaySpec item) {
        return new DelayNestedImpl(item);
    }

    public JVMChaosSpecFluent.DelayNested<A> editDelay() {
        return withNewDelayLike(getDelay());
    }

    public JVMChaosSpecFluent.DelayNested<A> editOrNewDelay() {
        return withNewDelayLike(getDelay() != null ? getDelay(): new JVMDelaySpecBuilder().build());
    }

    public JVMChaosSpecFluent.DelayNested<A> editOrNewDelayLike(JVMDelaySpec item) {
        return withNewDelayLike(getDelay() != null ? getDelay(): item);
    }

    
/**
 * This method has been deprecated, please use method buildDelay4servlet instead.
 * @return The buildable object.
 */
@Deprecated public ServletDelaySpec getDelay4servlet() {
        return this.delay4servlet!=null?this.delay4servlet.build():null;
    }

    public ServletDelaySpec buildDelay4servlet() {
        return this.delay4servlet!=null?this.delay4servlet.build():null;
    }

    public A withDelay4servlet(ServletDelaySpec delay4servlet) {
        _visitables.get("delay4servlet").remove(this.delay4servlet);
        if (delay4servlet!=null){ this.delay4servlet= new ServletDelaySpecBuilder(delay4servlet); _visitables.get("delay4servlet").add(this.delay4servlet);} return (A) this;
    }

    public Boolean hasDelay4servlet() {
        return this.delay4servlet != null;
    }

    public A withNewDelay4servlet(String method,Integer offset,String querystring,String requestpath,Integer time) {
        return (A)withDelay4servlet(new ServletDelaySpec(method, offset, querystring, requestpath, time));
    }

    public JVMChaosSpecFluent.Delay4servletNested<A> withNewDelay4servlet() {
        return new Delay4servletNestedImpl();
    }

    public JVMChaosSpecFluent.Delay4servletNested<A> withNewDelay4servletLike(ServletDelaySpec item) {
        return new Delay4servletNestedImpl(item);
    }

    public JVMChaosSpecFluent.Delay4servletNested<A> editDelay4servlet() {
        return withNewDelay4servletLike(getDelay4servlet());
    }

    public JVMChaosSpecFluent.Delay4servletNested<A> editOrNewDelay4servlet() {
        return withNewDelay4servletLike(getDelay4servlet() != null ? getDelay4servlet(): new ServletDelaySpecBuilder().build());
    }

    public JVMChaosSpecFluent.Delay4servletNested<A> editOrNewDelay4servletLike(ServletDelaySpec item) {
        return withNewDelay4servletLike(getDelay4servlet() != null ? getDelay4servlet(): item);
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public Integer getEffectcount() {
        return this.effectcount;
    }

    public A withEffectcount(Integer effectcount) {
        this.effectcount=effectcount; return (A) this;
    }

    public Boolean hasEffectcount() {
        return this.effectcount != null;
    }

    public A withNewEffectcount(String arg1) {
        return (A)withEffectcount(new Integer(arg1));
    }

    public A withNewEffectcount(int arg1) {
        return (A)withEffectcount(new Integer(arg1));
    }

    public Integer getEffectpercent() {
        return this.effectpercent;
    }

    public A withEffectpercent(Integer effectpercent) {
        this.effectpercent=effectpercent; return (A) this;
    }

    public Boolean hasEffectpercent() {
        return this.effectpercent != null;
    }

    public A withNewEffectpercent(String arg1) {
        return (A)withEffectpercent(new Integer(arg1));
    }

    public A withNewEffectpercent(int arg1) {
        return (A)withEffectpercent(new Integer(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildOom instead.
 * @return The buildable object.
 */
@Deprecated public JVMOOMSpec getOom() {
        return this.oom!=null?this.oom.build():null;
    }

    public JVMOOMSpec buildOom() {
        return this.oom!=null?this.oom.build():null;
    }

    public A withOom(JVMOOMSpec oom) {
        _visitables.get("oom").remove(this.oom);
        if (oom!=null){ this.oom= new JVMOOMSpecBuilder(oom); _visitables.get("oom").add(this.oom);} return (A) this;
    }

    public Boolean hasOom() {
        return this.oom != null;
    }

    public JVMChaosSpecFluent.OomNested<A> withNewOom() {
        return new OomNestedImpl();
    }

    public JVMChaosSpecFluent.OomNested<A> withNewOomLike(JVMOOMSpec item) {
        return new OomNestedImpl(item);
    }

    public JVMChaosSpecFluent.OomNested<A> editOom() {
        return withNewOomLike(getOom());
    }

    public JVMChaosSpecFluent.OomNested<A> editOrNewOom() {
        return withNewOomLike(getOom() != null ? getOom(): new JVMOOMSpecBuilder().build());
    }

    public JVMChaosSpecFluent.OomNested<A> editOrNewOomLike(JVMOOMSpec item) {
        return withNewOomLike(getOom() != null ? getOom(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReturn instead.
 * @return The buildable object.
 */
@Deprecated public JVMReturnSpec getReturn() {
        return this._return!=null?this._return.build():null;
    }

    public JVMReturnSpec buildReturn() {
        return this._return!=null?this._return.build():null;
    }

    public A withReturn(JVMReturnSpec _return) {
        _visitables.get("_return").remove(this._return);
        if (_return!=null){ this._return= new JVMReturnSpecBuilder(_return); _visitables.get("_return").add(this._return);} return (A) this;
    }

    public Boolean hasReturn() {
        return this._return != null;
    }

    public A withNewReturn(Boolean after,String classname,String methodname,String value) {
        return (A)withReturn(new JVMReturnSpec(after, classname, methodname, value));
    }

    public JVMChaosSpecFluent.ReturnNested<A> withNewReturn() {
        return new ReturnNestedImpl();
    }

    public JVMChaosSpecFluent.ReturnNested<A> withNewReturnLike(JVMReturnSpec item) {
        return new ReturnNestedImpl(item);
    }

    public JVMChaosSpecFluent.ReturnNested<A> editReturn() {
        return withNewReturnLike(getReturn());
    }

    public JVMChaosSpecFluent.ReturnNested<A> editOrNewReturn() {
        return withNewReturnLike(getReturn() != null ? getReturn(): new JVMReturnSpecBuilder().build());
    }

    public JVMChaosSpecFluent.ReturnNested<A> editOrNewReturnLike(JVMReturnSpec item) {
        return withNewReturnLike(getReturn() != null ? getReturn(): item);
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public JVMChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public JVMChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public JVMChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public JVMChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public JVMChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildScript instead.
 * @return The buildable object.
 */
@Deprecated public JVMScriptSpec getScript() {
        return this.script!=null?this.script.build():null;
    }

    public JVMScriptSpec buildScript() {
        return this.script!=null?this.script.build():null;
    }

    public A withScript(JVMScriptSpec script) {
        _visitables.get("script").remove(this.script);
        if (script!=null){ this.script= new JVMScriptSpecBuilder(script); _visitables.get("script").add(this.script);} return (A) this;
    }

    public Boolean hasScript() {
        return this.script != null;
    }

    public JVMChaosSpecFluent.ScriptNested<A> withNewScript() {
        return new ScriptNestedImpl();
    }

    public JVMChaosSpecFluent.ScriptNested<A> withNewScriptLike(JVMScriptSpec item) {
        return new ScriptNestedImpl(item);
    }

    public JVMChaosSpecFluent.ScriptNested<A> editScript() {
        return withNewScriptLike(getScript());
    }

    public JVMChaosSpecFluent.ScriptNested<A> editOrNewScript() {
        return withNewScriptLike(getScript() != null ? getScript(): new JVMScriptSpecBuilder().build());
    }

    public JVMChaosSpecFluent.ScriptNested<A> editOrNewScriptLike(JVMScriptSpec item) {
        return withNewScriptLike(getScript() != null ? getScript(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public JVMChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public JVMChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public JVMChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public JVMChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTce instead.
 * @return The buildable object.
 */
@Deprecated public JVMExceptionSpec getTce() {
        return this.tce!=null?this.tce.build():null;
    }

    public JVMExceptionSpec buildTce() {
        return this.tce!=null?this.tce.build():null;
    }

    public A withTce(JVMExceptionSpec tce) {
        _visitables.get("tce").remove(this.tce);
        if (tce!=null){ this.tce= new JVMExceptionSpecBuilder(tce); _visitables.get("tce").add(this.tce);} return (A) this;
    }

    public Boolean hasTce() {
        return this.tce != null;
    }

    public A withNewTce(Boolean after,String classname,String exception,String message,String methodname) {
        return (A)withTce(new JVMExceptionSpec(after, classname, exception, message, methodname));
    }

    public JVMChaosSpecFluent.TceNested<A> withNewTce() {
        return new TceNestedImpl();
    }

    public JVMChaosSpecFluent.TceNested<A> withNewTceLike(JVMExceptionSpec item) {
        return new TceNestedImpl(item);
    }

    public JVMChaosSpecFluent.TceNested<A> editTce() {
        return withNewTceLike(getTce());
    }

    public JVMChaosSpecFluent.TceNested<A> editOrNewTce() {
        return withNewTceLike(getTce() != null ? getTce(): new JVMExceptionSpecBuilder().build());
    }

    public JVMChaosSpecFluent.TceNested<A> editOrNewTceLike(JVMExceptionSpec item) {
        return withNewTceLike(getTce() != null ? getTce(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTce4servlet instead.
 * @return The buildable object.
 */
@Deprecated public ServletExceptionSpec getTce4servlet() {
        return this.tce4servlet!=null?this.tce4servlet.build():null;
    }

    public ServletExceptionSpec buildTce4servlet() {
        return this.tce4servlet!=null?this.tce4servlet.build():null;
    }

    public A withTce4servlet(ServletExceptionSpec tce4servlet) {
        _visitables.get("tce4servlet").remove(this.tce4servlet);
        if (tce4servlet!=null){ this.tce4servlet= new ServletExceptionSpecBuilder(tce4servlet); _visitables.get("tce4servlet").add(this.tce4servlet);} return (A) this;
    }

    public Boolean hasTce4servlet() {
        return this.tce4servlet != null;
    }

    public A withNewTce4servlet(String exception,String message,String method,String querystring,String requestpath) {
        return (A)withTce4servlet(new ServletExceptionSpec(exception, message, method, querystring, requestpath));
    }

    public JVMChaosSpecFluent.Tce4servletNested<A> withNewTce4servlet() {
        return new Tce4servletNestedImpl();
    }

    public JVMChaosSpecFluent.Tce4servletNested<A> withNewTce4servletLike(ServletExceptionSpec item) {
        return new Tce4servletNestedImpl(item);
    }

    public JVMChaosSpecFluent.Tce4servletNested<A> editTce4servlet() {
        return withNewTce4servletLike(getTce4servlet());
    }

    public JVMChaosSpecFluent.Tce4servletNested<A> editOrNewTce4servlet() {
        return withNewTce4servletLike(getTce4servlet() != null ? getTce4servlet(): new ServletExceptionSpecBuilder().build());
    }

    public JVMChaosSpecFluent.Tce4servletNested<A> editOrNewTce4servletLike(ServletExceptionSpec item) {
        return withNewTce4servletLike(getTce4servlet() != null ? getTce4servlet(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JVMChaosSpecFluentImpl that = (JVMChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (cfl != null ? !cfl.equals(that.cfl) :that.cfl != null) return false;
        if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
        if (delay4servlet != null ? !delay4servlet.equals(that.delay4servlet) :that.delay4servlet != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (effectcount != null ? !effectcount.equals(that.effectcount) :that.effectcount != null) return false;
        if (effectpercent != null ? !effectpercent.equals(that.effectpercent) :that.effectpercent != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (oom != null ? !oom.equals(that.oom) :that.oom != null) return false;
        if (_return != null ? !_return.equals(that._return) :that._return != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (script != null ? !script.equals(that.script) :that.script != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (tce != null ? !tce.equals(that.tce) :that.tce != null) return false;
        if (tce4servlet != null ? !tce4servlet.equals(that.tce4servlet) :that.tce4servlet != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  cfl,  delay,  delay4servlet,  duration,  effectcount,  effectpercent,  mode,  oom,  _return,  scheduler,  script,  selector,  tce,  tce4servlet,  value,  super.hashCode());
    }

    public class CflNestedImpl<N> extends JVMCpufullloadSpecFluentImpl<JVMChaosSpecFluent.CflNested<N>> implements JVMChaosSpecFluent.CflNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMCpufullloadSpecBuilder builder;

            CflNestedImpl(JVMCpufullloadSpec item) {
                this.builder = new JVMCpufullloadSpecBuilder(this, item);
                        
            }

            CflNestedImpl() {
                this.builder = new JVMCpufullloadSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withCfl(builder.build());
            }

            public N endCfl() {
                return and();
            }
    }


    public class DelayNestedImpl<N> extends JVMDelaySpecFluentImpl<JVMChaosSpecFluent.DelayNested<N>> implements JVMChaosSpecFluent.DelayNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMDelaySpecBuilder builder;

            DelayNestedImpl(JVMDelaySpec item) {
                this.builder = new JVMDelaySpecBuilder(this, item);
                        
            }

            DelayNestedImpl() {
                this.builder = new JVMDelaySpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withDelay(builder.build());
            }

            public N endDelay() {
                return and();
            }
    }


    public class Delay4servletNestedImpl<N> extends ServletDelaySpecFluentImpl<JVMChaosSpecFluent.Delay4servletNested<N>> implements JVMChaosSpecFluent.Delay4servletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServletDelaySpecBuilder builder;

            Delay4servletNestedImpl(ServletDelaySpec item) {
                this.builder = new ServletDelaySpecBuilder(this, item);
                        
            }

            Delay4servletNestedImpl() {
                this.builder = new ServletDelaySpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withDelay4servlet(builder.build());
            }

            public N endDelay4servlet() {
                return and();
            }
    }


    public class OomNestedImpl<N> extends JVMOOMSpecFluentImpl<JVMChaosSpecFluent.OomNested<N>> implements JVMChaosSpecFluent.OomNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMOOMSpecBuilder builder;

            OomNestedImpl(JVMOOMSpec item) {
                this.builder = new JVMOOMSpecBuilder(this, item);
                        
            }

            OomNestedImpl() {
                this.builder = new JVMOOMSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withOom(builder.build());
            }

            public N endOom() {
                return and();
            }
    }


    public class ReturnNestedImpl<N> extends JVMReturnSpecFluentImpl<JVMChaosSpecFluent.ReturnNested<N>> implements JVMChaosSpecFluent.ReturnNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMReturnSpecBuilder builder;

            ReturnNestedImpl(JVMReturnSpec item) {
                this.builder = new JVMReturnSpecBuilder(this, item);
                        
            }

            ReturnNestedImpl() {
                this.builder = new JVMReturnSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withReturn(builder.build());
            }

            public N endReturn() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<JVMChaosSpecFluent.SchedulerNested<N>> implements JVMChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class ScriptNestedImpl<N> extends JVMScriptSpecFluentImpl<JVMChaosSpecFluent.ScriptNested<N>> implements JVMChaosSpecFluent.ScriptNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMScriptSpecBuilder builder;

            ScriptNestedImpl(JVMScriptSpec item) {
                this.builder = new JVMScriptSpecBuilder(this, item);
                        
            }

            ScriptNestedImpl() {
                this.builder = new JVMScriptSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withScript(builder.build());
            }

            public N endScript() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<JVMChaosSpecFluent.SelectorNested<N>> implements JVMChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


    public class TceNestedImpl<N> extends JVMExceptionSpecFluentImpl<JVMChaosSpecFluent.TceNested<N>> implements JVMChaosSpecFluent.TceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final JVMExceptionSpecBuilder builder;

            TceNestedImpl(JVMExceptionSpec item) {
                this.builder = new JVMExceptionSpecBuilder(this, item);
                        
            }

            TceNestedImpl() {
                this.builder = new JVMExceptionSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withTce(builder.build());
            }

            public N endTce() {
                return and();
            }
    }


    public class Tce4servletNestedImpl<N> extends ServletExceptionSpecFluentImpl<JVMChaosSpecFluent.Tce4servletNested<N>> implements JVMChaosSpecFluent.Tce4servletNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ServletExceptionSpecBuilder builder;

            Tce4servletNestedImpl(ServletExceptionSpec item) {
                this.builder = new ServletExceptionSpecBuilder(this, item);
                        
            }

            Tce4servletNestedImpl() {
                this.builder = new ServletExceptionSpecBuilder(this);
                        
            }

            public N and() {
                return (N) JVMChaosSpecFluentImpl.this.withTce4servlet(builder.build());
            }

            public N endTce4servlet() {
                return and();
            }
    }


}
