package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IoChaosStatusBuilder extends IoChaosStatusFluentImpl<IoChaosStatusBuilder> implements VisitableBuilder<IoChaosStatus,IoChaosStatusBuilder> {

    IoChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IoChaosStatusBuilder() {
        this(true);
    }

    public IoChaosStatusBuilder(Boolean validationEnabled) {
        this(new IoChaosStatus(), validationEnabled);
    }

    public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IoChaosStatus(), validationEnabled);
    }

    public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,IoChaosStatus instance) {
        this(fluent, instance, true);
    }

    public IoChaosStatusBuilder(IoChaosStatusFluent<?> fluent,IoChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public IoChaosStatusBuilder(IoChaosStatus instance) {
        this(instance,true);
    }

    public IoChaosStatusBuilder(IoChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableIoChaosStatus build() {
        EditableIoChaosStatus buildable = new EditableIoChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IoChaosStatusBuilder that = (IoChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
