package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HTTPChaosStatusBuilder extends HTTPChaosStatusFluentImpl<HTTPChaosStatusBuilder> implements VisitableBuilder<HTTPChaosStatus,HTTPChaosStatusBuilder> {

    HTTPChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPChaosStatusBuilder() {
        this(true);
    }

    public HTTPChaosStatusBuilder(Boolean validationEnabled) {
        this(new HTTPChaosStatus(), validationEnabled);
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new HTTPChaosStatus(), validationEnabled);
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance) {
        this(fluent, instance, true);
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatusFluent<?> fluent,HTTPChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatus instance) {
        this(instance,true);
    }

    public HTTPChaosStatusBuilder(HTTPChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableHTTPChaosStatus build() {
        EditableHTTPChaosStatus buildable = new EditableHTTPChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        HTTPChaosStatusBuilder that = (HTTPChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
