package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DNSChaosStatusBuilder extends DNSChaosStatusFluentImpl<DNSChaosStatusBuilder> implements VisitableBuilder<DNSChaosStatus,DNSChaosStatusBuilder> {

    DNSChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DNSChaosStatusBuilder() {
        this(true);
    }

    public DNSChaosStatusBuilder(Boolean validationEnabled) {
        this(new DNSChaosStatus(), validationEnabled);
    }

    public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DNSChaosStatus(), validationEnabled);
    }

    public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance) {
        this(fluent, instance, true);
    }

    public DNSChaosStatusBuilder(DNSChaosStatusFluent<?> fluent,DNSChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public DNSChaosStatusBuilder(DNSChaosStatus instance) {
        this(instance,true);
    }

    public DNSChaosStatusBuilder(DNSChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDNSChaosStatus build() {
        EditableDNSChaosStatus buildable = new EditableDNSChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DNSChaosStatusBuilder that = (DNSChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
