package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class LossSpecBuilder extends LossSpecFluentImpl<LossSpecBuilder> implements VisitableBuilder<LossSpec,LossSpecBuilder> {

    LossSpecFluent<?> fluent;
    Boolean validationEnabled;

    public LossSpecBuilder() {
        this(true);
    }

    public LossSpecBuilder(Boolean validationEnabled) {
        this(new LossSpec(), validationEnabled);
    }

    public LossSpecBuilder(LossSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public LossSpecBuilder(LossSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new LossSpec(), validationEnabled);
    }

    public LossSpecBuilder(LossSpecFluent<?> fluent,LossSpec instance) {
        this(fluent, instance, true);
    }

    public LossSpecBuilder(LossSpecFluent<?> fluent,LossSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCorrelation(instance.getCorrelation()); 
        fluent.withLoss(instance.getLoss()); 
        this.validationEnabled = validationEnabled; 
    }

    public LossSpecBuilder(LossSpec instance) {
        this(instance,true);
    }

    public LossSpecBuilder(LossSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCorrelation(instance.getCorrelation()); 
        this.withLoss(instance.getLoss()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableLossSpec build() {
        EditableLossSpec buildable = new EditableLossSpec(fluent.getCorrelation(),fluent.getLoss());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        LossSpecBuilder that = (LossSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
