package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface SelectorSpecFluent<A extends SelectorSpecFluent<A>> extends Fluent<A> {


    public A addToAnnotationSelectors(String key,String value);
    public A addToAnnotationSelectors(Map<String,String> map);
    public A removeFromAnnotationSelectors(String key);
    public A removeFromAnnotationSelectors(Map<String,String> map);
    public Map<String,String> getAnnotationSelectors();
    public A withAnnotationSelectors(Map<String,String> annotationSelectors);
    public Boolean hasAnnotationSelectors();
    public A addToFieldSelectors(String key,String value);
    public A addToFieldSelectors(Map<String,String> map);
    public A removeFromFieldSelectors(String key);
    public A removeFromFieldSelectors(Map<String,String> map);
    public Map<String,String> getFieldSelectors();
    public A withFieldSelectors(Map<String,String> fieldSelectors);
    public Boolean hasFieldSelectors();
    public A addToLabelSelectors(String key,String value);
    public A addToLabelSelectors(Map<String,String> map);
    public A removeFromLabelSelectors(String key);
    public A removeFromLabelSelectors(Map<String,String> map);
    public Map<String,String> getLabelSelectors();
    public A withLabelSelectors(Map<String,String> labelSelectors);
    public Boolean hasLabelSelectors();
    public A addToNamespaces(int index,String item);
    public A setToNamespaces(int index,String item);
    public A addToNamespaces(String... items);
    public A addAllToNamespaces(Collection<String> items);
    public A removeFromNamespaces(String... items);
    public A removeAllFromNamespaces(Collection<String> items);
    public List<String> getNamespaces();
    public String getNamespace(int index);
    public String getFirstNamespace();
    public String getLastNamespace();
    public String getMatchingNamespace(Predicate<String> predicate);
    public Boolean hasMatchingNamespace(Predicate<String> predicate);
    public A withNamespaces(List<String> namespaces);
    public A withNamespaces(String... namespaces);
    public Boolean hasNamespaces();
    public A addNewNamespace(String arg1);
    public A addNewNamespace(StringBuilder arg1);
    public A addNewNamespace(StringBuffer arg1);
    public A addToNodeSelectors(String key,String value);
    public A addToNodeSelectors(Map<String,String> map);
    public A removeFromNodeSelectors(String key);
    public A removeFromNodeSelectors(Map<String,String> map);
    public Map<String,String> getNodeSelectors();
    public A withNodeSelectors(Map<String,String> nodeSelectors);
    public Boolean hasNodeSelectors();
    public A addToNodes(int index,String item);
    public A setToNodes(int index,String item);
    public A addToNodes(String... items);
    public A addAllToNodes(Collection<String> items);
    public A removeFromNodes(String... items);
    public A removeAllFromNodes(Collection<String> items);
    public List<String> getNodes();
    public String getNode(int index);
    public String getFirstNode();
    public String getLastNode();
    public String getMatchingNode(Predicate<String> predicate);
    public Boolean hasMatchingNode(Predicate<String> predicate);
    public A withNodes(List<String> nodes);
    public A withNodes(String... nodes);
    public Boolean hasNodes();
    public A addNewNode(String arg1);
    public A addNewNode(StringBuilder arg1);
    public A addNewNode(StringBuffer arg1);
    public A addToPodPhaseSelectors(int index,String item);
    public A setToPodPhaseSelectors(int index,String item);
    public A addToPodPhaseSelectors(String... items);
    public A addAllToPodPhaseSelectors(Collection<String> items);
    public A removeFromPodPhaseSelectors(String... items);
    public A removeAllFromPodPhaseSelectors(Collection<String> items);
    public List<String> getPodPhaseSelectors();
    public String getPodPhaseSelector(int index);
    public String getFirstPodPhaseSelector();
    public String getLastPodPhaseSelector();
    public String getMatchingPodPhaseSelector(Predicate<String> predicate);
    public Boolean hasMatchingPodPhaseSelector(Predicate<String> predicate);
    public A withPodPhaseSelectors(List<String> podPhaseSelectors);
    public A withPodPhaseSelectors(String... podPhaseSelectors);
    public Boolean hasPodPhaseSelectors();
    public A addNewPodPhaseSelector(String arg1);
    public A addNewPodPhaseSelector(StringBuilder arg1);
    public A addNewPodPhaseSelector(StringBuffer arg1);
    public A addToPods(String key,List<String> value);
    public A addToPods(Map<String,List<String>> map);
    public A removeFromPods(String key);
    public A removeFromPods(Map<String,List<String>> map);
    public Map<String,List<String>> getPods();
    public A withPods(Map<String,List<String>> pods);
    public Boolean hasPods();
}
