package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KernelChaosSpecBuilder extends KernelChaosSpecFluentImpl<KernelChaosSpecBuilder> implements VisitableBuilder<KernelChaosSpec,KernelChaosSpecBuilder> {

    KernelChaosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KernelChaosSpecBuilder() {
        this(true);
    }

    public KernelChaosSpecBuilder(Boolean validationEnabled) {
        this(new KernelChaosSpec(), validationEnabled);
    }

    public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KernelChaosSpec(), validationEnabled);
    }

    public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance) {
        this(fluent, instance, true);
    }

    public KernelChaosSpecBuilder(KernelChaosSpecFluent<?> fluent,KernelChaosSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDuration(instance.getDuration()); 
        fluent.withFailKernRequest(instance.getFailKernRequest()); 
        fluent.withMode(instance.getMode()); 
        fluent.withScheduler(instance.getScheduler()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public KernelChaosSpecBuilder(KernelChaosSpec instance) {
        this(instance,true);
    }

    public KernelChaosSpecBuilder(KernelChaosSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withDuration(instance.getDuration()); 
        this.withFailKernRequest(instance.getFailKernRequest()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableKernelChaosSpec build() {
        EditableKernelChaosSpec buildable = new EditableKernelChaosSpec(fluent.getDuration(),fluent.getFailKernRequest(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KernelChaosSpecBuilder that = (KernelChaosSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
