package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class IoChaosSpecFluentImpl<A extends IoChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IoChaosSpecFluent<A> {

    private String action;
    private AttrOverrideSpecBuilder attr;
    private String delay;
    private String duration;
    private Integer errno;
    private List<String> methods;
    private String mode;
    private String path;
    private Integer percent;
    private SchedulerSpecBuilder scheduler;
    private SelectorSpecBuilder selector;
    private String value;
    private String volumePath;

    public IoChaosSpecFluentImpl() {
    }

    public IoChaosSpecFluentImpl(IoChaosSpec instance) {
        this.withAction(instance.getAction()); 
        this.withAttr(instance.getAttr()); 
        this.withDelay(instance.getDelay()); 
        this.withDuration(instance.getDuration()); 
        this.withErrno(instance.getErrno()); 
        this.withMethods(instance.getMethods()); 
        this.withMode(instance.getMode()); 
        this.withPath(instance.getPath()); 
        this.withPercent(instance.getPercent()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
        this.withVolumePath(instance.getVolumePath()); 
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action=action; return (A) this;
    }

    public Boolean hasAction() {
        return this.action != null;
    }

    public A withNewAction(String arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuilder arg1) {
        return (A)withAction(new String(arg1));
    }

    public A withNewAction(StringBuffer arg1) {
        return (A)withAction(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAttr instead.
 * @return The buildable object.
 */
@Deprecated public AttrOverrideSpec getAttr() {
        return this.attr!=null?this.attr.build():null;
    }

    public AttrOverrideSpec buildAttr() {
        return this.attr!=null?this.attr.build():null;
    }

    public A withAttr(AttrOverrideSpec attr) {
        _visitables.get("attr").remove(this.attr);
        if (attr!=null){ this.attr= new AttrOverrideSpecBuilder(attr); _visitables.get("attr").add(this.attr);} return (A) this;
    }

    public Boolean hasAttr() {
        return this.attr != null;
    }

    public IoChaosSpecFluent.AttrNested<A> withNewAttr() {
        return new AttrNestedImpl();
    }

    public IoChaosSpecFluent.AttrNested<A> withNewAttrLike(AttrOverrideSpec item) {
        return new AttrNestedImpl(item);
    }

    public IoChaosSpecFluent.AttrNested<A> editAttr() {
        return withNewAttrLike(getAttr());
    }

    public IoChaosSpecFluent.AttrNested<A> editOrNewAttr() {
        return withNewAttrLike(getAttr() != null ? getAttr(): new AttrOverrideSpecBuilder().build());
    }

    public IoChaosSpecFluent.AttrNested<A> editOrNewAttrLike(AttrOverrideSpec item) {
        return withNewAttrLike(getAttr() != null ? getAttr(): item);
    }

    public String getDelay() {
        return this.delay;
    }

    public A withDelay(String delay) {
        this.delay=delay; return (A) this;
    }

    public Boolean hasDelay() {
        return this.delay != null;
    }

    public A withNewDelay(String arg1) {
        return (A)withDelay(new String(arg1));
    }

    public A withNewDelay(StringBuilder arg1) {
        return (A)withDelay(new String(arg1));
    }

    public A withNewDelay(StringBuffer arg1) {
        return (A)withDelay(new String(arg1));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public Integer getErrno() {
        return this.errno;
    }

    public A withErrno(Integer errno) {
        this.errno=errno; return (A) this;
    }

    public Boolean hasErrno() {
        return this.errno != null;
    }

    public A addToMethods(int index,String item) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        this.methods.add(index, item);
        return (A)this;
    }

    public A setToMethods(int index,String item) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        this.methods.set(index, item); return (A)this;
    }

    public A addToMethods(String... items) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {this.methods = new ArrayList<String>();}
        for (String item : items) {this.methods.add(item);} return (A)this;
    }

    public A removeFromMethods(String... items) {
        for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public A removeAllFromMethods(Collection<String> items) {
        for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public String getMethod(int index) {
        return this.methods.get(index);
    }

    public String getFirstMethod() {
        return this.methods.get(0);
    }

    public String getLastMethod() {
        return this.methods.get(methods.size() - 1);
    }

    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMethods(List<String> methods) {
        if (this.methods != null) { _visitables.get("methods").removeAll(this.methods);}
        if (methods != null) {this.methods = new ArrayList<String>(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
    }

    public A withMethods(String... methods) {
        if (this.methods != null) {this.methods.clear();}
        if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
    }

    public Boolean hasMethods() {
        return methods != null && !methods.isEmpty();
    }

    public A addNewMethod(String arg1) {
        return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuilder arg1) {
        return (A)addToMethods(new String(arg1));
    }

    public A addNewMethod(StringBuffer arg1) {
        return (A)addToMethods(new String(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path=path; return (A) this;
    }

    public Boolean hasPath() {
        return this.path != null;
    }

    public A withNewPath(String arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuilder arg1) {
        return (A)withPath(new String(arg1));
    }

    public A withNewPath(StringBuffer arg1) {
        return (A)withPath(new String(arg1));
    }

    public Integer getPercent() {
        return this.percent;
    }

    public A withPercent(Integer percent) {
        this.percent=percent; return (A) this;
    }

    public Boolean hasPercent() {
        return this.percent != null;
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public IoChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public IoChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public IoChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public IoChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public IoChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public IoChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public IoChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public IoChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public IoChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public IoChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public String getVolumePath() {
        return this.volumePath;
    }

    public A withVolumePath(String volumePath) {
        this.volumePath=volumePath; return (A) this;
    }

    public Boolean hasVolumePath() {
        return this.volumePath != null;
    }

    public A withNewVolumePath(String arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(StringBuilder arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public A withNewVolumePath(StringBuffer arg1) {
        return (A)withVolumePath(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IoChaosSpecFluentImpl that = (IoChaosSpecFluentImpl) o;
        if (action != null ? !action.equals(that.action) :that.action != null) return false;
        if (attr != null ? !attr.equals(that.attr) :that.attr != null) return false;
        if (delay != null ? !delay.equals(that.delay) :that.delay != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (errno != null ? !errno.equals(that.errno) :that.errno != null) return false;
        if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (percent != null ? !percent.equals(that.percent) :that.percent != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        if (volumePath != null ? !volumePath.equals(that.volumePath) :that.volumePath != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(action,  attr,  delay,  duration,  errno,  methods,  mode,  path,  percent,  scheduler,  selector,  value,  volumePath,  super.hashCode());
    }

    public class AttrNestedImpl<N> extends AttrOverrideSpecFluentImpl<IoChaosSpecFluent.AttrNested<N>> implements IoChaosSpecFluent.AttrNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AttrOverrideSpecBuilder builder;

            AttrNestedImpl(AttrOverrideSpec item) {
                this.builder = new AttrOverrideSpecBuilder(this, item);
                        
            }

            AttrNestedImpl() {
                this.builder = new AttrOverrideSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosSpecFluentImpl.this.withAttr(builder.build());
            }

            public N endAttr() {
                return and();
            }
    }


    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<IoChaosSpecFluent.SchedulerNested<N>> implements IoChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<IoChaosSpecFluent.SelectorNested<N>> implements IoChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) IoChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
