package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RawIPSetFluentImpl<A extends RawIPSetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RawIPSetFluent<A> {

    private List<String> cidrs;
    private String name;
    private String source;

    public RawIPSetFluentImpl() {
    }

    public RawIPSetFluentImpl(RawIPSet instance) {
        this.withCidrs(instance.getCidrs()); 
        this.withName(instance.getName()); 
        this.withSource(instance.getSource()); 
    }

    public A addToCidrs(int index,String item) {
        if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
        this.cidrs.add(index, item);
        return (A)this;
    }

    public A setToCidrs(int index,String item) {
        if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
        this.cidrs.set(index, item); return (A)this;
    }

    public A addToCidrs(String... items) {
        if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
        for (String item : items) {this.cidrs.add(item);} return (A)this;
    }

    public A addAllToCidrs(Collection<String> items) {
        if (this.cidrs == null) {this.cidrs = new ArrayList<String>();}
        for (String item : items) {this.cidrs.add(item);} return (A)this;
    }

    public A removeFromCidrs(String... items) {
        for (String item : items) {if (this.cidrs!= null){ this.cidrs.remove(item);}} return (A)this;
    }

    public A removeAllFromCidrs(Collection<String> items) {
        for (String item : items) {if (this.cidrs!= null){ this.cidrs.remove(item);}} return (A)this;
    }

    public List<String> getCidrs() {
        return this.cidrs;
    }

    public String getCidr(int index) {
        return this.cidrs.get(index);
    }

    public String getFirstCidr() {
        return this.cidrs.get(0);
    }

    public String getLastCidr() {
        return this.cidrs.get(cidrs.size() - 1);
    }

    public String getMatchingCidr(Predicate<String> predicate) {
        for (String item: cidrs) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCidr(Predicate<String> predicate) {
        for (String item: cidrs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCidrs(List<String> cidrs) {
        if (this.cidrs != null) { _visitables.get("cidrs").removeAll(this.cidrs);}
        if (cidrs != null) {this.cidrs = new ArrayList<String>(); for (String item : cidrs){this.addToCidrs(item);}} else { this.cidrs = null;} return (A) this;
    }

    public A withCidrs(String... cidrs) {
        if (this.cidrs != null) {this.cidrs.clear();}
        if (cidrs != null) {for (String item :cidrs){ this.addToCidrs(item);}} return (A) this;
    }

    public Boolean hasCidrs() {
        return cidrs != null && !cidrs.isEmpty();
    }

    public A addNewCidr(String arg1) {
        return (A)addToCidrs(new String(arg1));
    }

    public A addNewCidr(StringBuilder arg1) {
        return (A)addToCidrs(new String(arg1));
    }

    public A addNewCidr(StringBuffer arg1) {
        return (A)addToCidrs(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RawIPSetFluentImpl that = (RawIPSetFluentImpl) o;
        if (cidrs != null ? !cidrs.equals(that.cidrs) :that.cidrs != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cidrs,  name,  source,  super.hashCode());
    }

}
