package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KernelChaosStatusBuilder extends KernelChaosStatusFluentImpl<KernelChaosStatusBuilder> implements VisitableBuilder<KernelChaosStatus,KernelChaosStatusBuilder> {

    KernelChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public KernelChaosStatusBuilder() {
        this(true);
    }

    public KernelChaosStatusBuilder(Boolean validationEnabled) {
        this(new KernelChaosStatus(), validationEnabled);
    }

    public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KernelChaosStatus(), validationEnabled);
    }

    public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,KernelChaosStatus instance) {
        this(fluent, instance, true);
    }

    public KernelChaosStatusBuilder(KernelChaosStatusFluent<?> fluent,KernelChaosStatus instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public KernelChaosStatusBuilder(KernelChaosStatus instance) {
        this(instance,true);
    }

    public KernelChaosStatusBuilder(KernelChaosStatus instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableKernelChaosStatus build() {
        EditableKernelChaosStatus buildable = new EditableKernelChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getPhase(),fluent.getReason(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KernelChaosStatusBuilder that = (KernelChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
