package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CPUStressorFluentImpl<A extends CPUStressorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CPUStressorFluent<A> {

    private Integer load;
    private List<String> options;
    private Integer workers;

    public CPUStressorFluentImpl() {
    }

    public CPUStressorFluentImpl(CPUStressor instance) {
        this.withLoad(instance.getLoad()); 
        this.withOptions(instance.getOptions()); 
        this.withWorkers(instance.getWorkers()); 
    }

    public Integer getLoad() {
        return this.load;
    }

    public A withLoad(Integer load) {
        this.load=load; return (A) this;
    }

    public Boolean hasLoad() {
        return this.load != null;
    }

    public A addToOptions(int index,String item) {
        if (this.options == null) {this.options = new ArrayList<String>();}
        this.options.add(index, item);
        return (A)this;
    }

    public A setToOptions(int index,String item) {
        if (this.options == null) {this.options = new ArrayList<String>();}
        this.options.set(index, item); return (A)this;
    }

    public A addToOptions(String... items) {
        if (this.options == null) {this.options = new ArrayList<String>();}
        for (String item : items) {this.options.add(item);} return (A)this;
    }

    public A addAllToOptions(Collection<String> items) {
        if (this.options == null) {this.options = new ArrayList<String>();}
        for (String item : items) {this.options.add(item);} return (A)this;
    }

    public A removeFromOptions(String... items) {
        for (String item : items) {if (this.options!= null){ this.options.remove(item);}} return (A)this;
    }

    public A removeAllFromOptions(Collection<String> items) {
        for (String item : items) {if (this.options!= null){ this.options.remove(item);}} return (A)this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public String getOption(int index) {
        return this.options.get(index);
    }

    public String getFirstOption() {
        return this.options.get(0);
    }

    public String getLastOption() {
        return this.options.get(options.size() - 1);
    }

    public String getMatchingOption(Predicate<String> predicate) {
        for (String item: options) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingOption(Predicate<String> predicate) {
        for (String item: options) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOptions(List<String> options) {
        if (this.options != null) { _visitables.get("options").removeAll(this.options);}
        if (options != null) {this.options = new ArrayList<String>(); for (String item : options){this.addToOptions(item);}} else { this.options = null;} return (A) this;
    }

    public A withOptions(String... options) {
        if (this.options != null) {this.options.clear();}
        if (options != null) {for (String item :options){ this.addToOptions(item);}} return (A) this;
    }

    public Boolean hasOptions() {
        return options != null && !options.isEmpty();
    }

    public A addNewOption(String arg1) {
        return (A)addToOptions(new String(arg1));
    }

    public A addNewOption(StringBuilder arg1) {
        return (A)addToOptions(new String(arg1));
    }

    public A addNewOption(StringBuffer arg1) {
        return (A)addToOptions(new String(arg1));
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public A withWorkers(Integer workers) {
        this.workers=workers; return (A) this;
    }

    public Boolean hasWorkers() {
        return this.workers != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CPUStressorFluentImpl that = (CPUStressorFluentImpl) o;
        if (load != null ? !load.equals(that.load) :that.load != null) return false;
        if (options != null ? !options.equals(that.options) :that.options != null) return false;
        if (workers != null ? !workers.equals(that.workers) :that.workers != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(load,  options,  workers,  super.hashCode());
    }

}
