package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface TimeChaosFluent<A extends TimeChaosFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public TimeChaosFluent.MetadataNested<A> withNewMetadata();
    public TimeChaosFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public TimeChaosFluent.MetadataNested<A> editMetadata();
    public TimeChaosFluent.MetadataNested<A> editOrNewMetadata();
    public TimeChaosFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public TimeChaosSpec getSpec();
    public TimeChaosSpec buildSpec();
    public A withSpec(TimeChaosSpec spec);
    public Boolean hasSpec();
    public TimeChaosFluent.SpecNested<A> withNewSpec();
    public TimeChaosFluent.SpecNested<A> withNewSpecLike(TimeChaosSpec item);
    public TimeChaosFluent.SpecNested<A> editSpec();
    public TimeChaosFluent.SpecNested<A> editOrNewSpec();
    public TimeChaosFluent.SpecNested<A> editOrNewSpecLike(TimeChaosSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public TimeChaosStatus getStatus();
    public TimeChaosStatus buildStatus();
    public A withStatus(TimeChaosStatus status);
    public Boolean hasStatus();
    public TimeChaosFluent.StatusNested<A> withNewStatus();
    public TimeChaosFluent.StatusNested<A> withNewStatusLike(TimeChaosStatus item);
    public TimeChaosFluent.StatusNested<A> editStatus();
    public TimeChaosFluent.StatusNested<A> editOrNewStatus();
    public TimeChaosFluent.StatusNested<A> editOrNewStatusLike(TimeChaosStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<TimeChaosFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeChaosSpecFluent<TimeChaosFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeChaosStatusFluent<TimeChaosFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
