package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KernelChaosListFluent<A extends KernelChaosListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,KernelChaos item);
    public A setToItems(int index,KernelChaos item);
    public A addToItems(KernelChaos... items);
    public A addAllToItems(Collection<KernelChaos> items);
    public A removeFromItems(KernelChaos... items);
    public A removeAllFromItems(Collection<KernelChaos> items);
    public A removeMatchingFromItems(Predicate<KernelChaosBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<KernelChaos> getItems();
    public List<KernelChaos> buildItems();
    public KernelChaos buildItem(int index);
    public KernelChaos buildFirstItem();
    public KernelChaos buildLastItem();
    public KernelChaos buildMatchingItem(Predicate<KernelChaosBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<KernelChaosBuilder> predicate);
    public A withItems(List<KernelChaos> items);
    public A withItems(KernelChaos... items);
    public Boolean hasItems();
    public KernelChaosListFluent.ItemsNested<A> addNewItem();
    public KernelChaosListFluent.ItemsNested<A> addNewItemLike(KernelChaos item);
    public KernelChaosListFluent.ItemsNested<A> setNewItemLike(int index,KernelChaos item);
    public KernelChaosListFluent.ItemsNested<A> editItem(int index);
    public KernelChaosListFluent.ItemsNested<A> editFirstItem();
    public KernelChaosListFluent.ItemsNested<A> editLastItem();
    public KernelChaosListFluent.ItemsNested<A> editMatchingItem(Predicate<KernelChaosBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KernelChaosFluent<KernelChaosListFluent.ItemsNested<N>> {

            public N and();
            public N endItem();    }


}
