package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IoChaosSpecBuilder extends IoChaosSpecFluentImpl<IoChaosSpecBuilder> implements VisitableBuilder<IoChaosSpec,IoChaosSpecBuilder> {

    IoChaosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IoChaosSpecBuilder() {
        this(true);
    }

    public IoChaosSpecBuilder(Boolean validationEnabled) {
        this(new IoChaosSpec(), validationEnabled);
    }

    public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IoChaosSpec(), validationEnabled);
    }

    public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,IoChaosSpec instance) {
        this(fluent, instance, true);
    }

    public IoChaosSpecBuilder(IoChaosSpecFluent<?> fluent,IoChaosSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAction(instance.getAction()); 
        fluent.withAttr(instance.getAttr()); 
        fluent.withDelay(instance.getDelay()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withErrno(instance.getErrno()); 
        fluent.withMethods(instance.getMethods()); 
        fluent.withMode(instance.getMode()); 
        fluent.withPath(instance.getPath()); 
        fluent.withPercent(instance.getPercent()); 
        fluent.withScheduler(instance.getScheduler()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withValue(instance.getValue()); 
        fluent.withVolumePath(instance.getVolumePath()); 
        this.validationEnabled = validationEnabled; 
    }

    public IoChaosSpecBuilder(IoChaosSpec instance) {
        this(instance,true);
    }

    public IoChaosSpecBuilder(IoChaosSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAction(instance.getAction()); 
        this.withAttr(instance.getAttr()); 
        this.withDelay(instance.getDelay()); 
        this.withDuration(instance.getDuration()); 
        this.withErrno(instance.getErrno()); 
        this.withMethods(instance.getMethods()); 
        this.withMode(instance.getMode()); 
        this.withPath(instance.getPath()); 
        this.withPercent(instance.getPercent()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
        this.withVolumePath(instance.getVolumePath()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableIoChaosSpec build() {
        EditableIoChaosSpec buildable = new EditableIoChaosSpec(fluent.getAction(),fluent.getAttr(),fluent.getDelay(),fluent.getDuration(),fluent.getErrno(),fluent.getMethods(),fluent.getMode(),fluent.getPath(),fluent.getPercent(),fluent.getScheduler(),fluent.getSelector(),fluent.getValue(),fluent.getVolumePath());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IoChaosSpecBuilder that = (IoChaosSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
