package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface IoChaosFluent<A extends IoChaosFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public IoChaosFluent.MetadataNested<A> withNewMetadata();
    public IoChaosFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IoChaosFluent.MetadataNested<A> editMetadata();
    public IoChaosFluent.MetadataNested<A> editOrNewMetadata();
    public IoChaosFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public IoChaosSpec getSpec();
    public IoChaosSpec buildSpec();
    public A withSpec(IoChaosSpec spec);
    public Boolean hasSpec();
    public IoChaosFluent.SpecNested<A> withNewSpec();
    public IoChaosFluent.SpecNested<A> withNewSpecLike(IoChaosSpec item);
    public IoChaosFluent.SpecNested<A> editSpec();
    public IoChaosFluent.SpecNested<A> editOrNewSpec();
    public IoChaosFluent.SpecNested<A> editOrNewSpecLike(IoChaosSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public IoChaosStatus getStatus();
    public IoChaosStatus buildStatus();
    public A withStatus(IoChaosStatus status);
    public Boolean hasStatus();
    public IoChaosFluent.StatusNested<A> withNewStatus();
    public IoChaosFluent.StatusNested<A> withNewStatusLike(IoChaosStatus item);
    public IoChaosFluent.StatusNested<A> editStatus();
    public IoChaosFluent.StatusNested<A> editOrNewStatus();
    public IoChaosFluent.StatusNested<A> editOrNewStatusLike(IoChaosStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<IoChaosFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IoChaosSpecFluent<IoChaosFluent.SpecNested<N>> {

            public N and();
            public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IoChaosStatusFluent<IoChaosFluent.StatusNested<N>> {

            public N and();
            public N endStatus();    }


}
