package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class FailKernRequestBuilder extends FailKernRequestFluentImpl<FailKernRequestBuilder> implements VisitableBuilder<FailKernRequest,FailKernRequestBuilder> {

    FailKernRequestFluent<?> fluent;
    Boolean validationEnabled;

    public FailKernRequestBuilder() {
        this(true);
    }

    public FailKernRequestBuilder(Boolean validationEnabled) {
        this(new FailKernRequest(), validationEnabled);
    }

    public FailKernRequestBuilder(FailKernRequestFluent<?> fluent) {
        this(fluent, true);
    }

    public FailKernRequestBuilder(FailKernRequestFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new FailKernRequest(), validationEnabled);
    }

    public FailKernRequestBuilder(FailKernRequestFluent<?> fluent,FailKernRequest instance) {
        this(fluent, instance, true);
    }

    public FailKernRequestBuilder(FailKernRequestFluent<?> fluent,FailKernRequest instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCallchain(instance.getCallchain()); 
        fluent.withFailtype(instance.getFailtype()); 
        fluent.withHeaders(instance.getHeaders()); 
        fluent.withProbability(instance.getProbability()); 
        fluent.withTimes(instance.getTimes()); 
        this.validationEnabled = validationEnabled; 
    }

    public FailKernRequestBuilder(FailKernRequest instance) {
        this(instance,true);
    }

    public FailKernRequestBuilder(FailKernRequest instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCallchain(instance.getCallchain()); 
        this.withFailtype(instance.getFailtype()); 
        this.withHeaders(instance.getHeaders()); 
        this.withProbability(instance.getProbability()); 
        this.withTimes(instance.getTimes()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableFailKernRequest build() {
        EditableFailKernRequest buildable = new EditableFailKernRequest(fluent.getCallchain(),fluent.getFailtype(),fluent.getHeaders(),fluent.getProbability(),fluent.getTimes());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        FailKernRequestBuilder that = (FailKernRequestBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
