package io.fabric8.chaosmesh.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class CorruptSpecFluentImpl<A extends CorruptSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CorruptSpecFluent<A> {

    private String correlation;
    private String corrupt;

    public CorruptSpecFluentImpl() {
    }

    public CorruptSpecFluentImpl(CorruptSpec instance) {
        this.withCorrelation(instance.getCorrelation()); 
        this.withCorrupt(instance.getCorrupt()); 
    }

    public String getCorrelation() {
        return this.correlation;
    }

    public A withCorrelation(String correlation) {
        this.correlation=correlation; return (A) this;
    }

    public Boolean hasCorrelation() {
        return this.correlation != null;
    }

    public A withNewCorrelation(String arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuilder arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuffer arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public String getCorrupt() {
        return this.corrupt;
    }

    public A withCorrupt(String corrupt) {
        this.corrupt=corrupt; return (A) this;
    }

    public Boolean hasCorrupt() {
        return this.corrupt != null;
    }

    public A withNewCorrupt(String arg1) {
        return (A)withCorrupt(new String(arg1));
    }

    public A withNewCorrupt(StringBuilder arg1) {
        return (A)withCorrupt(new String(arg1));
    }

    public A withNewCorrupt(StringBuffer arg1) {
        return (A)withCorrupt(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CorruptSpecFluentImpl that = (CorruptSpecFluentImpl) o;
        if (correlation != null ? !correlation.equals(that.correlation) :that.correlation != null) return false;
        if (corrupt != null ? !corrupt.equals(that.corrupt) :that.corrupt != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(correlation,  corrupt,  super.hashCode());
    }

}
