package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class TimeChaosSpecFluentImpl<A extends TimeChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TimeChaosSpecFluent<A> {

    private List<String> clockIds;
    private List<String> containerNames;
    private String duration;
    private String mode;
    private SchedulerSpecBuilder scheduler;
    private SelectorSpecBuilder selector;
    private String timeOffset;
    private String value;

    public TimeChaosSpecFluentImpl() {
    }

    public TimeChaosSpecFluentImpl(TimeChaosSpec instance) {
        this.withClockIds(instance.getClockIds()); 
        this.withContainerNames(instance.getContainerNames()); 
        this.withDuration(instance.getDuration()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withTimeOffset(instance.getTimeOffset()); 
        this.withValue(instance.getValue()); 
    }

    public A addToClockIds(int index,String item) {
        if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
        this.clockIds.add(index, item);
        return (A)this;
    }

    public A setToClockIds(int index,String item) {
        if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
        this.clockIds.set(index, item); return (A)this;
    }

    public A addToClockIds(String... items) {
        if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
        for (String item : items) {this.clockIds.add(item);} return (A)this;
    }

    public A addAllToClockIds(Collection<String> items) {
        if (this.clockIds == null) {this.clockIds = new ArrayList<String>();}
        for (String item : items) {this.clockIds.add(item);} return (A)this;
    }

    public A removeFromClockIds(String... items) {
        for (String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
    }

    public A removeAllFromClockIds(Collection<String> items) {
        for (String item : items) {if (this.clockIds!= null){ this.clockIds.remove(item);}} return (A)this;
    }

    public List<String> getClockIds() {
        return this.clockIds;
    }

    public String getClockId(int index) {
        return this.clockIds.get(index);
    }

    public String getFirstClockId() {
        return this.clockIds.get(0);
    }

    public String getLastClockId() {
        return this.clockIds.get(clockIds.size() - 1);
    }

    public String getMatchingClockId(Predicate<String> predicate) {
        for (String item: clockIds) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingClockId(Predicate<String> predicate) {
        for (String item: clockIds) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClockIds(List<String> clockIds) {
        if (this.clockIds != null) { _visitables.get("clockIds").removeAll(this.clockIds);}
        if (clockIds != null) {this.clockIds = new ArrayList<String>(); for (String item : clockIds){this.addToClockIds(item);}} else { this.clockIds = null;} return (A) this;
    }

    public A withClockIds(String... clockIds) {
        if (this.clockIds != null) {this.clockIds.clear();}
        if (clockIds != null) {for (String item :clockIds){ this.addToClockIds(item);}} return (A) this;
    }

    public Boolean hasClockIds() {
        return clockIds != null && !clockIds.isEmpty();
    }

    public A addNewClockId(String arg1) {
        return (A)addToClockIds(new String(arg1));
    }

    public A addNewClockId(StringBuilder arg1) {
        return (A)addToClockIds(new String(arg1));
    }

    public A addNewClockId(StringBuffer arg1) {
        return (A)addToClockIds(new String(arg1));
    }

    public A addToContainerNames(int index,String item) {
        if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
        this.containerNames.add(index, item);
        return (A)this;
    }

    public A setToContainerNames(int index,String item) {
        if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
        this.containerNames.set(index, item); return (A)this;
    }

    public A addToContainerNames(String... items) {
        if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
        for (String item : items) {this.containerNames.add(item);} return (A)this;
    }

    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {this.containerNames = new ArrayList<String>();}
        for (String item : items) {this.containerNames.add(item);} return (A)this;
    }

    public A removeFromContainerNames(String... items) {
        for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
    }

    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {if (this.containerNames!= null){ this.containerNames.remove(item);}} return (A)this;
    }

    public List<String> getContainerNames() {
        return this.containerNames;
    }

    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    public String getLastContainerName() {
        return this.containerNames.get(containerNames.size() - 1);
    }

    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item: containerNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item: containerNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withContainerNames(List<String> containerNames) {
        if (this.containerNames != null) { _visitables.get("containerNames").removeAll(this.containerNames);}
        if (containerNames != null) {this.containerNames = new ArrayList<String>(); for (String item : containerNames){this.addToContainerNames(item);}} else { this.containerNames = null;} return (A) this;
    }

    public A withContainerNames(String... containerNames) {
        if (this.containerNames != null) {this.containerNames.clear();}
        if (containerNames != null) {for (String item :containerNames){ this.addToContainerNames(item);}} return (A) this;
    }

    public Boolean hasContainerNames() {
        return containerNames != null && !containerNames.isEmpty();
    }

    public A addNewContainerName(String arg1) {
        return (A)addToContainerNames(new String(arg1));
    }

    public A addNewContainerName(StringBuilder arg1) {
        return (A)addToContainerNames(new String(arg1));
    }

    public A addNewContainerName(StringBuffer arg1) {
        return (A)addToContainerNames(new String(arg1));
    }

    public String getDuration() {
        return this.duration;
    }

    public A withDuration(String duration) {
        this.duration=duration; return (A) this;
    }

    public Boolean hasDuration() {
        return this.duration != null;
    }

    public A withNewDuration(String arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuilder arg1) {
        return (A)withDuration(new String(arg1));
    }

    public A withNewDuration(StringBuffer arg1) {
        return (A)withDuration(new String(arg1));
    }

    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public SchedulerSpec getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public SchedulerSpec buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(SchedulerSpec scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new SchedulerSpecBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String cron) {
        return (A)withScheduler(new SchedulerSpec(cron));
    }

    public TimeChaosSpecFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public TimeChaosSpecFluent.SchedulerNested<A> withNewSchedulerLike(SchedulerSpec item) {
        return new SchedulerNestedImpl(item);
    }

    public TimeChaosSpecFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public TimeChaosSpecFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new SchedulerSpecBuilder().build());
    }

    public TimeChaosSpecFluent.SchedulerNested<A> editOrNewSchedulerLike(SchedulerSpec item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public TimeChaosSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public TimeChaosSpecFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public TimeChaosSpecFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public TimeChaosSpecFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public TimeChaosSpecFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getTimeOffset() {
        return this.timeOffset;
    }

    public A withTimeOffset(String timeOffset) {
        this.timeOffset=timeOffset; return (A) this;
    }

    public Boolean hasTimeOffset() {
        return this.timeOffset != null;
    }

    public A withNewTimeOffset(String arg1) {
        return (A)withTimeOffset(new String(arg1));
    }

    public A withNewTimeOffset(StringBuilder arg1) {
        return (A)withTimeOffset(new String(arg1));
    }

    public A withNewTimeOffset(StringBuffer arg1) {
        return (A)withTimeOffset(new String(arg1));
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TimeChaosSpecFluentImpl that = (TimeChaosSpecFluentImpl) o;
        if (clockIds != null ? !clockIds.equals(that.clockIds) :that.clockIds != null) return false;
        if (containerNames != null ? !containerNames.equals(that.containerNames) :that.containerNames != null) return false;
        if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (timeOffset != null ? !timeOffset.equals(that.timeOffset) :that.timeOffset != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clockIds,  containerNames,  duration,  mode,  scheduler,  selector,  timeOffset,  value,  super.hashCode());
    }

    public class SchedulerNestedImpl<N> extends SchedulerSpecFluentImpl<TimeChaosSpecFluent.SchedulerNested<N>> implements TimeChaosSpecFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulerSpecBuilder builder;

            SchedulerNestedImpl(SchedulerSpec item) {
                this.builder = new SchedulerSpecBuilder(this, item);
                        
            }

            SchedulerNestedImpl() {
                this.builder = new SchedulerSpecBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosSpecFluentImpl.this.withScheduler(builder.build());
            }

            public N endScheduler() {
                return and();
            }
    }


    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<TimeChaosSpecFluent.SelectorNested<N>> implements TimeChaosSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

            SelectorNestedImpl(SelectorSpec item) {
                this.builder = new SelectorSpecBuilder(this, item);
                        
            }

            SelectorNestedImpl() {
                this.builder = new SelectorSpecBuilder(this);
                        
            }

            public N and() {
                return (N) TimeChaosSpecFluentImpl.this.withSelector(builder.build());
            }

            public N endSelector() {
                return and();
            }
    }


}
