package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TargetBuilder extends TargetFluentImpl<TargetBuilder> implements VisitableBuilder<Target,TargetBuilder> {

    TargetFluent<?> fluent;
    Boolean validationEnabled;

    public TargetBuilder() {
        this(true);
    }

    public TargetBuilder(Boolean validationEnabled) {
        this(new Target(), validationEnabled);
    }

    public TargetBuilder(TargetFluent<?> fluent) {
        this(fluent, true);
    }

    public TargetBuilder(TargetFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Target(), validationEnabled);
    }

    public TargetBuilder(TargetFluent<?> fluent,Target instance) {
        this(fluent, instance, true);
    }

    public TargetBuilder(TargetFluent<?> fluent,Target instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMode(instance.getMode()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public TargetBuilder(Target instance) {
        this(instance,true);
    }

    public TargetBuilder(Target instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withMode(instance.getMode()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableTarget build() {
        EditableTarget buildable = new EditableTarget(fluent.getMode(),fluent.getSelector(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TargetBuilder that = (TargetBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
