package io.fabric8.chaosmesh.v1alpha1;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class StressInstanceFluentImpl<A extends StressInstanceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StressInstanceFluent<A> {

    private String startTime;
    private String uid;

    public StressInstanceFluentImpl() {
    }

    public StressInstanceFluentImpl(StressInstance instance) {
        this.withStartTime(instance.getStartTime()); 
        this.withUid(instance.getUid()); 
    }

    public String getStartTime() {
        return this.startTime;
    }

    public A withStartTime(String startTime) {
        this.startTime=startTime; return (A) this;
    }

    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    public A withNewStartTime(String arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuilder arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public A withNewStartTime(StringBuffer arg1) {
        return (A)withStartTime(new String(arg1));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StressInstanceFluentImpl that = (StressInstanceFluentImpl) o;
        if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(startTime,  uid,  super.hashCode());
    }

}
