package io.fabric8.chaosmesh.v1alpha1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ReorderSpecFluentImpl<A extends ReorderSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReorderSpecFluent<A> {

    private String correlation;
    private Integer gap;
    private String reorder;

    public ReorderSpecFluentImpl() {
    }

    public ReorderSpecFluentImpl(ReorderSpec instance) {
        this.withCorrelation(instance.getCorrelation()); 
        this.withGap(instance.getGap()); 
        this.withReorder(instance.getReorder()); 
    }

    public String getCorrelation() {
        return this.correlation;
    }

    public A withCorrelation(String correlation) {
        this.correlation=correlation; return (A) this;
    }

    public Boolean hasCorrelation() {
        return this.correlation != null;
    }

    public A withNewCorrelation(String arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuilder arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuffer arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public Integer getGap() {
        return this.gap;
    }

    public A withGap(Integer gap) {
        this.gap=gap; return (A) this;
    }

    public Boolean hasGap() {
        return this.gap != null;
    }

    public String getReorder() {
        return this.reorder;
    }

    public A withReorder(String reorder) {
        this.reorder=reorder; return (A) this;
    }

    public Boolean hasReorder() {
        return this.reorder != null;
    }

    public A withNewReorder(String arg1) {
        return (A)withReorder(new String(arg1));
    }

    public A withNewReorder(StringBuilder arg1) {
        return (A)withReorder(new String(arg1));
    }

    public A withNewReorder(StringBuffer arg1) {
        return (A)withReorder(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ReorderSpecFluentImpl that = (ReorderSpecFluentImpl) o;
        if (correlation != null ? !correlation.equals(that.correlation) :that.correlation != null) return false;
        if (gap != null ? !gap.equals(that.gap) :that.gap != null) return false;
        if (reorder != null ? !reorder.equals(that.reorder) :that.reorder != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(correlation,  gap,  reorder,  super.hashCode());
    }

}
