package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReorderSpecBuilder extends ReorderSpecFluentImpl<ReorderSpecBuilder> implements VisitableBuilder<ReorderSpec,ReorderSpecBuilder> {

    ReorderSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ReorderSpecBuilder() {
        this(true);
    }

    public ReorderSpecBuilder(Boolean validationEnabled) {
        this(new ReorderSpec(), validationEnabled);
    }

    public ReorderSpecBuilder(ReorderSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new ReorderSpec(), validationEnabled);
    }

    public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,ReorderSpec instance) {
        this(fluent, instance, true);
    }

    public ReorderSpecBuilder(ReorderSpecFluent<?> fluent,ReorderSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCorrelation(instance.getCorrelation()); 
        fluent.withGap(instance.getGap()); 
        fluent.withReorder(instance.getReorder()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReorderSpecBuilder(ReorderSpec instance) {
        this(instance,true);
    }

    public ReorderSpecBuilder(ReorderSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCorrelation(instance.getCorrelation()); 
        this.withGap(instance.getGap()); 
        this.withReorder(instance.getReorder()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableReorderSpec build() {
        EditableReorderSpec buildable = new EditableReorderSpec(fluent.getCorrelation(),fluent.getGap(),fluent.getReorder());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReorderSpecBuilder that = (ReorderSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
