package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KernelChaosBuilder extends KernelChaosFluentImpl<KernelChaosBuilder> implements VisitableBuilder<KernelChaos,KernelChaosBuilder> {

    KernelChaosFluent<?> fluent;
    Boolean validationEnabled;

    public KernelChaosBuilder() {
        this(true);
    }

    public KernelChaosBuilder(Boolean validationEnabled) {
        this(new KernelChaos(), validationEnabled);
    }

    public KernelChaosBuilder(KernelChaosFluent<?> fluent) {
        this(fluent, true);
    }

    public KernelChaosBuilder(KernelChaosFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new KernelChaos(), validationEnabled);
    }

    public KernelChaosBuilder(KernelChaosFluent<?> fluent,KernelChaos instance) {
        this(fluent, instance, true);
    }

    public KernelChaosBuilder(KernelChaosFluent<?> fluent,KernelChaos instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public KernelChaosBuilder(KernelChaos instance) {
        this(instance,true);
    }

    public KernelChaosBuilder(KernelChaos instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableKernelChaos build() {
        EditableKernelChaos buildable = new EditableKernelChaos(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KernelChaosBuilder that = (KernelChaosBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
