package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DelaySpecBuilder extends DelaySpecFluentImpl<DelaySpecBuilder> implements VisitableBuilder<DelaySpec,DelaySpecBuilder> {

    DelaySpecFluent<?> fluent;
    Boolean validationEnabled;

    public DelaySpecBuilder() {
        this(true);
    }

    public DelaySpecBuilder(Boolean validationEnabled) {
        this(new DelaySpec(), validationEnabled);
    }

    public DelaySpecBuilder(DelaySpecFluent<?> fluent) {
        this(fluent, true);
    }

    public DelaySpecBuilder(DelaySpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new DelaySpec(), validationEnabled);
    }

    public DelaySpecBuilder(DelaySpecFluent<?> fluent,DelaySpec instance) {
        this(fluent, instance, true);
    }

    public DelaySpecBuilder(DelaySpecFluent<?> fluent,DelaySpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withCorrelation(instance.getCorrelation()); 
        fluent.withJitter(instance.getJitter()); 
        fluent.withLatency(instance.getLatency()); 
        fluent.withReorder(instance.getReorder()); 
        this.validationEnabled = validationEnabled; 
    }

    public DelaySpecBuilder(DelaySpec instance) {
        this(instance,true);
    }

    public DelaySpecBuilder(DelaySpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withCorrelation(instance.getCorrelation()); 
        this.withJitter(instance.getJitter()); 
        this.withLatency(instance.getLatency()); 
        this.withReorder(instance.getReorder()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.chaosmesh.v1alpha1.EditableDelaySpec build() {
        EditableDelaySpec buildable = new EditableDelaySpec(fluent.getCorrelation(),fluent.getJitter(),fluent.getLatency(),fluent.getReorder());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DelaySpecBuilder that = (DelaySpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
