package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PodChaosStatusBuilder extends PodChaosStatusFluentImpl<PodChaosStatusBuilder> implements VisitableBuilder<PodChaosStatus,PodChaosStatusBuilder> {

    PodChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PodChaosStatusBuilder() { 
        this(true);
    }


    public PodChaosStatusBuilder(Boolean validationEnabled) { 
        this(new PodChaosStatus(), validationEnabled);
    }


    public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new PodChaosStatus(), validationEnabled);
    }


    public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance) { 
        this(fluent, instance, true);
    }


    public PodChaosStatusBuilder(PodChaosStatusFluent<?> fluent,PodChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public PodChaosStatusBuilder(PodChaosStatus instance) { 
        this(instance,true);
    }


    public PodChaosStatusBuilder(PodChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditablePodChaosStatus build() {
        EditablePodChaosStatus buildable = new EditablePodChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getPhase(),fluent.getReason(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodChaosStatusBuilder that = (PodChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
