package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface KernelChaosFluent<A extends KernelChaosFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KernelChaosFluent.MetadataNested<A> withNewMetadata();
    public KernelChaosFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KernelChaosFluent.MetadataNested<A> editMetadata();
    public KernelChaosFluent.MetadataNested<A> editOrNewMetadata();
    public KernelChaosFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KernelChaosSpec getSpec();
    public KernelChaosSpec buildSpec();
    public A withSpec(KernelChaosSpec spec);
    public Boolean hasSpec();
    public KernelChaosFluent.SpecNested<A> withNewSpec();
    public KernelChaosFluent.SpecNested<A> withNewSpecLike(KernelChaosSpec item);
    public KernelChaosFluent.SpecNested<A> editSpec();
    public KernelChaosFluent.SpecNested<A> editOrNewSpec();
    public KernelChaosFluent.SpecNested<A> editOrNewSpecLike(KernelChaosSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KernelChaosStatus getStatus();
    public KernelChaosStatus buildStatus();
    public A withStatus(KernelChaosStatus status);
    public Boolean hasStatus();
    public KernelChaosFluent.StatusNested<A> withNewStatus();
    public KernelChaosFluent.StatusNested<A> withNewStatusLike(KernelChaosStatus item);
    public KernelChaosFluent.StatusNested<A> editStatus();
    public KernelChaosFluent.StatusNested<A> editOrNewStatus();
    public KernelChaosFluent.StatusNested<A> editOrNewStatusLike(KernelChaosStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KernelChaosFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KernelChaosSpecFluent<KernelChaosFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KernelChaosStatusFluent<KernelChaosFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
