package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface TimeChaosListFluent<A extends TimeChaosListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,TimeChaos item);
    public A setToItems(int index,TimeChaos item);
    public A addToItems(TimeChaos... items);
    public A addAllToItems(Collection<TimeChaos> items);
    public A removeFromItems(TimeChaos... items);
    public A removeAllFromItems(Collection<TimeChaos> items);
    public A removeMatchingFromItems(Predicate<TimeChaosBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<TimeChaos> getItems();
    public List<TimeChaos> buildItems();
    public TimeChaos buildItem(int index);
    public TimeChaos buildFirstItem();
    public TimeChaos buildLastItem();
    public TimeChaos buildMatchingItem(Predicate<TimeChaosBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<TimeChaosBuilder> predicate);
    public A withItems(List<TimeChaos> items);
    public A withItems(TimeChaos... items);
    public Boolean hasItems();
    public TimeChaosListFluent.ItemsNested<A> addNewItem();
    public TimeChaosListFluent.ItemsNested<A> addNewItemLike(TimeChaos item);
    public TimeChaosListFluent.ItemsNested<A> setNewItemLike(int index,TimeChaos item);
    public TimeChaosListFluent.ItemsNested<A> editItem(int index);
    public TimeChaosListFluent.ItemsNested<A> editFirstItem();
    public TimeChaosListFluent.ItemsNested<A> editLastItem();
    public TimeChaosListFluent.ItemsNested<A> editMatchingItem(Predicate<TimeChaosBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeChaosFluent<TimeChaosListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
