package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.lang.Object;
import java.util.Map;

public class StressChaosStatusFluentImpl<A extends StressChaosStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StressChaosStatusFluent<A> {

    private ExperimentStatusBuilder experiment;
    private String failedMessage;
    private Map<String,StressInstance> instances;
    private String phase;
    private String reason;
    private ScheduleStatusBuilder scheduler;

    public StressChaosStatusFluentImpl() { 
    }


    public StressChaosStatusFluentImpl(StressChaosStatus instance) { 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withInstances(instance.getInstances()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
    }


    
/**
 * This method has been deprecated, please use method buildExperiment instead.
 * @return The buildable object.
 */
@Deprecated public ExperimentStatus getExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public ExperimentStatus buildExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public A withExperiment(ExperimentStatus experiment) {
        _visitables.get("experiment").remove(this.experiment);
        if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} return (A) this;
    }

    public Boolean hasExperiment() {
        return this.experiment != null;
    }

    public StressChaosStatusFluent.ExperimentNested<A> withNewExperiment() {
        return new ExperimentNestedImpl();
    }

    public StressChaosStatusFluent.ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
        return new ExperimentNestedImpl(item);
    }

    public StressChaosStatusFluent.ExperimentNested<A> editExperiment() {
        return withNewExperimentLike(getExperiment());
    }

    public StressChaosStatusFluent.ExperimentNested<A> editOrNewExperiment() {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): new ExperimentStatusBuilder().build());
    }

    public StressChaosStatusFluent.ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): item);
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public A withFailedMessage(String failedMessage) {
        this.failedMessage=failedMessage; return (A) this;
    }

    public Boolean hasFailedMessage() {
        return this.failedMessage != null;
    }

    public A withNewFailedMessage(String arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(StringBuilder arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(StringBuffer arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A addToInstances(String key,StressInstance value) {
        if(this.instances == null && key != null && value != null) { this.instances = new LinkedHashMap<String,StressInstance>(); }
        if(key != null && value != null) {this.instances.put(key, value);} return (A)this;
    }

    public A addToInstances(Map<String,StressInstance> map) {
        if(this.instances == null && map != null) { this.instances = new LinkedHashMap<String,StressInstance>(); }
        if(map != null) { this.instances.putAll(map);} return (A)this;
    }

    public A removeFromInstances(String key) {
        if(this.instances == null) { return (A) this; }
        if(key != null && this.instances != null) {this.instances.remove(key);} return (A)this;
    }

    public A removeFromInstances(Map<String,StressInstance> map) {
        if(this.instances == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.instances != null){this.instances.remove(key);}}} return (A)this;
    }

    public Map<String,StressInstance> getInstances() {
        return this.instances;
    }

    public A withInstances(Map<String,StressInstance> instances) {
        if (instances == null) { this.instances =  null;} else {this.instances = new LinkedHashMap<String,StressInstance>(instances);} return (A) this;
    }

    public Boolean hasInstances() {
        return this.instances != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public ScheduleStatus getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public ScheduleStatus buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(ScheduleStatus scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new ScheduleStatusBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String nextRecover,String nextStart) {
        return (A)withScheduler(new ScheduleStatus(nextRecover, nextStart));
    }

    public StressChaosStatusFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public StressChaosStatusFluent.SchedulerNested<A> withNewSchedulerLike(ScheduleStatus item) {
        return new SchedulerNestedImpl(item);
    }

    public StressChaosStatusFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public StressChaosStatusFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new ScheduleStatusBuilder().build());
    }

    public StressChaosStatusFluent.SchedulerNested<A> editOrNewSchedulerLike(ScheduleStatus item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StressChaosStatusFluentImpl that = (StressChaosStatusFluentImpl) o;
        if (experiment != null ? !experiment.equals(that.experiment) :that.experiment != null) return false;
        if (failedMessage != null ? !failedMessage.equals(that.failedMessage) :that.failedMessage != null) return false;
        if (instances != null ? !instances.equals(that.instances) :that.instances != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(experiment,  failedMessage,  instances,  phase,  reason,  scheduler,  super.hashCode());
    }

    public class ExperimentNestedImpl<N> extends ExperimentStatusFluentImpl<StressChaosStatusFluent.ExperimentNested<N>> implements StressChaosStatusFluent.ExperimentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExperimentStatusBuilder builder;

        ExperimentNestedImpl(ExperimentStatus item) {
            this.builder = new ExperimentStatusBuilder(this, item);
        }

        ExperimentNestedImpl() {
            this.builder = new ExperimentStatusBuilder(this);
        }

        public N and() {
             return (N) StressChaosStatusFluentImpl.this.withExperiment(builder.build());
        }

        public N endExperiment() {
             return and();
        }
    }


    public class SchedulerNestedImpl<N> extends ScheduleStatusFluentImpl<StressChaosStatusFluent.SchedulerNested<N>> implements StressChaosStatusFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScheduleStatusBuilder builder;

        SchedulerNestedImpl(ScheduleStatus item) {
            this.builder = new ScheduleStatusBuilder(this, item);
        }

        SchedulerNestedImpl() {
            this.builder = new ScheduleStatusBuilder(this);
        }

        public N and() {
             return (N) StressChaosStatusFluentImpl.this.withScheduler(builder.build());
        }

        public N endScheduler() {
             return and();
        }
    }


}
