package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ExperimentStatusFluent<A extends ExperimentStatusFluent<A>> extends Fluent<A> {


    public String getDuration();
    public A withDuration(String duration);
    public Boolean hasDuration();
    public A withNewDuration(String arg1);
    public A withNewDuration(StringBuilder arg1);
    public A withNewDuration(StringBuffer arg1);
    public String getEndTime();
    public A withEndTime(String endTime);
    public Boolean hasEndTime();
    public A withNewEndTime(String arg1);
    public A withNewEndTime(StringBuilder arg1);
    public A withNewEndTime(StringBuffer arg1);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);
    public A addToPodRecords(int index,PodStatus item);
    public A setToPodRecords(int index,PodStatus item);
    public A addToPodRecords(PodStatus... items);
    public A addAllToPodRecords(Collection<PodStatus> items);
    public A removeFromPodRecords(PodStatus... items);
    public A removeAllFromPodRecords(Collection<PodStatus> items);
    public A removeMatchingFromPodRecords(Predicate<PodStatusBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPodRecords instead.
 * @return The buildable object.
 */
@Deprecated public List<PodStatus> getPodRecords();
    public List<PodStatus> buildPodRecords();
    public PodStatus buildPodRecord(int index);
    public PodStatus buildFirstPodRecord();
    public PodStatus buildLastPodRecord();
    public PodStatus buildMatchingPodRecord(Predicate<PodStatusBuilder> predicate);
    public Boolean hasMatchingPodRecord(Predicate<PodStatusBuilder> predicate);
    public A withPodRecords(List<PodStatus> podRecords);
    public A withPodRecords(PodStatus... podRecords);
    public Boolean hasPodRecords();
    public ExperimentStatusFluent.PodRecordsNested<A> addNewPodRecord();
    public ExperimentStatusFluent.PodRecordsNested<A> addNewPodRecordLike(PodStatus item);
    public ExperimentStatusFluent.PodRecordsNested<A> setNewPodRecordLike(int index,PodStatus item);
    public ExperimentStatusFluent.PodRecordsNested<A> editPodRecord(int index);
    public ExperimentStatusFluent.PodRecordsNested<A> editFirstPodRecord();
    public ExperimentStatusFluent.PodRecordsNested<A> editLastPodRecord();
    public ExperimentStatusFluent.PodRecordsNested<A> editMatchingPodRecord(Predicate<PodStatusBuilder> predicate);
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public A withNewReason(String arg1);
    public A withNewReason(StringBuilder arg1);
    public A withNewReason(StringBuffer arg1);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(String arg1);
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(StringBuffer arg1);
    public interface PodRecordsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodStatusFluent<ExperimentStatusFluent.PodRecordsNested<N>> {

        public N and();
        public N endPodRecord();    }


}
