package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BandwidthSpecBuilder extends BandwidthSpecFluentImpl<BandwidthSpecBuilder> implements VisitableBuilder<BandwidthSpec,BandwidthSpecBuilder> {

    BandwidthSpecFluent<?> fluent;
    Boolean validationEnabled;

    public BandwidthSpecBuilder() { 
        this(true);
    }


    public BandwidthSpecBuilder(Boolean validationEnabled) { 
        this(new BandwidthSpec(), validationEnabled);
    }


    public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new BandwidthSpec(), validationEnabled);
    }


    public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,BandwidthSpec instance) { 
        this(fluent, instance, true);
    }


    public BandwidthSpecBuilder(BandwidthSpecFluent<?> fluent,BandwidthSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withBuffer(instance.getBuffer()); 
        fluent.withLimit(instance.getLimit()); 
        fluent.withMinburst(instance.getMinburst()); 
        fluent.withPeakrate(instance.getPeakrate()); 
        fluent.withRate(instance.getRate()); 
        this.validationEnabled = validationEnabled; 
    }


    public BandwidthSpecBuilder(BandwidthSpec instance) { 
        this(instance,true);
    }


    public BandwidthSpecBuilder(BandwidthSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withBuffer(instance.getBuffer()); 
        this.withLimit(instance.getLimit()); 
        this.withMinburst(instance.getMinburst()); 
        this.withPeakrate(instance.getPeakrate()); 
        this.withRate(instance.getRate()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableBandwidthSpec build() {
        EditableBandwidthSpec buildable = new EditableBandwidthSpec(fluent.getBuffer(),fluent.getLimit(),fluent.getMinburst(),fluent.getPeakrate(),fluent.getRate());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BandwidthSpecBuilder that = (BandwidthSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
