package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TimespecBuilder extends TimespecFluentImpl<TimespecBuilder> implements VisitableBuilder<Timespec,TimespecBuilder> {

    TimespecFluent<?> fluent;
    Boolean validationEnabled;

    public TimespecBuilder() { 
        this(true);
    }


    public TimespecBuilder(Boolean validationEnabled) { 
        this(new Timespec(), validationEnabled);
    }


    public TimespecBuilder(TimespecFluent<?> fluent) { 
        this(fluent, true);
    }


    public TimespecBuilder(TimespecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new Timespec(), validationEnabled);
    }


    public TimespecBuilder(TimespecFluent<?> fluent,Timespec instance) { 
        this(fluent, instance, true);
    }


    public TimespecBuilder(TimespecFluent<?> fluent,Timespec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNsec(instance.getNsec()); 
        fluent.withSec(instance.getSec()); 
        this.validationEnabled = validationEnabled; 
    }


    public TimespecBuilder(Timespec instance) { 
        this(instance,true);
    }


    public TimespecBuilder(Timespec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNsec(instance.getNsec()); 
        this.withSec(instance.getSec()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableTimespec build() {
        EditableTimespec buildable = new EditableTimespec(fluent.getNsec(),fluent.getSec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TimespecBuilder that = (TimespecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
