package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TimeChaosSpecBuilder extends TimeChaosSpecFluentImpl<TimeChaosSpecBuilder> implements VisitableBuilder<TimeChaosSpec,TimeChaosSpecBuilder> {

    TimeChaosSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TimeChaosSpecBuilder() { 
        this(true);
    }


    public TimeChaosSpecBuilder(Boolean validationEnabled) { 
        this(new TimeChaosSpec(), validationEnabled);
    }


    public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent) { 
        this(fluent, true);
    }


    public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TimeChaosSpec(), validationEnabled);
    }


    public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,TimeChaosSpec instance) { 
        this(fluent, instance, true);
    }


    public TimeChaosSpecBuilder(TimeChaosSpecFluent<?> fluent,TimeChaosSpec instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withClockIds(instance.getClockIds()); 
        fluent.withContainerNames(instance.getContainerNames()); 
        fluent.withDuration(instance.getDuration()); 
        fluent.withMode(instance.getMode()); 
        fluent.withScheduler(instance.getScheduler()); 
        fluent.withSelector(instance.getSelector()); 
        fluent.withTimeOffset(instance.getTimeOffset()); 
        fluent.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }


    public TimeChaosSpecBuilder(TimeChaosSpec instance) { 
        this(instance,true);
    }


    public TimeChaosSpecBuilder(TimeChaosSpec instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withClockIds(instance.getClockIds()); 
        this.withContainerNames(instance.getContainerNames()); 
        this.withDuration(instance.getDuration()); 
        this.withMode(instance.getMode()); 
        this.withScheduler(instance.getScheduler()); 
        this.withSelector(instance.getSelector()); 
        this.withTimeOffset(instance.getTimeOffset()); 
        this.withValue(instance.getValue()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableTimeChaosSpec build() {
        EditableTimeChaosSpec buildable = new EditableTimeChaosSpec(fluent.getClockIds(),fluent.getContainerNames(),fluent.getDuration(),fluent.getMode(),fluent.getScheduler(),fluent.getSelector(),fluent.getTimeOffset(),fluent.getValue());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TimeChaosSpecBuilder that = (TimeChaosSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
