package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class StressorsFluentImpl<A extends StressorsFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StressorsFluent<A> {

    private CPUStressorBuilder cpu;
    private MemoryStressorBuilder memory;

    public StressorsFluentImpl() { 
    }


    public StressorsFluentImpl(Stressors instance) { 
        this.withCpu(instance.getCpu()); 
        this.withMemory(instance.getMemory()); 
    }


    
/**
 * This method has been deprecated, please use method buildCpu instead.
 * @return The buildable object.
 */
@Deprecated public CPUStressor getCpu() {
        return this.cpu!=null?this.cpu.build():null;
    }

    public CPUStressor buildCpu() {
        return this.cpu!=null?this.cpu.build():null;
    }

    public A withCpu(CPUStressor cpu) {
        _visitables.get("cpu").remove(this.cpu);
        if (cpu!=null){ this.cpu= new CPUStressorBuilder(cpu); _visitables.get("cpu").add(this.cpu);} return (A) this;
    }

    public Boolean hasCpu() {
        return this.cpu != null;
    }

    public StressorsFluent.CpuNested<A> withNewCpu() {
        return new CpuNestedImpl();
    }

    public StressorsFluent.CpuNested<A> withNewCpuLike(CPUStressor item) {
        return new CpuNestedImpl(item);
    }

    public StressorsFluent.CpuNested<A> editCpu() {
        return withNewCpuLike(getCpu());
    }

    public StressorsFluent.CpuNested<A> editOrNewCpu() {
        return withNewCpuLike(getCpu() != null ? getCpu(): new CPUStressorBuilder().build());
    }

    public StressorsFluent.CpuNested<A> editOrNewCpuLike(CPUStressor item) {
        return withNewCpuLike(getCpu() != null ? getCpu(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMemory instead.
 * @return The buildable object.
 */
@Deprecated public MemoryStressor getMemory() {
        return this.memory!=null?this.memory.build():null;
    }

    public MemoryStressor buildMemory() {
        return this.memory!=null?this.memory.build():null;
    }

    public A withMemory(MemoryStressor memory) {
        _visitables.get("memory").remove(this.memory);
        if (memory!=null){ this.memory= new MemoryStressorBuilder(memory); _visitables.get("memory").add(this.memory);} return (A) this;
    }

    public Boolean hasMemory() {
        return this.memory != null;
    }

    public StressorsFluent.MemoryNested<A> withNewMemory() {
        return new MemoryNestedImpl();
    }

    public StressorsFluent.MemoryNested<A> withNewMemoryLike(MemoryStressor item) {
        return new MemoryNestedImpl(item);
    }

    public StressorsFluent.MemoryNested<A> editMemory() {
        return withNewMemoryLike(getMemory());
    }

    public StressorsFluent.MemoryNested<A> editOrNewMemory() {
        return withNewMemoryLike(getMemory() != null ? getMemory(): new MemoryStressorBuilder().build());
    }

    public StressorsFluent.MemoryNested<A> editOrNewMemoryLike(MemoryStressor item) {
        return withNewMemoryLike(getMemory() != null ? getMemory(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        StressorsFluentImpl that = (StressorsFluentImpl) o;
        if (cpu != null ? !cpu.equals(that.cpu) :that.cpu != null) return false;
        if (memory != null ? !memory.equals(that.memory) :that.memory != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(cpu,  memory,  super.hashCode());
    }

    public class CpuNestedImpl<N> extends CPUStressorFluentImpl<StressorsFluent.CpuNested<N>> implements StressorsFluent.CpuNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final CPUStressorBuilder builder;

        CpuNestedImpl(CPUStressor item) {
            this.builder = new CPUStressorBuilder(this, item);
        }

        CpuNestedImpl() {
            this.builder = new CPUStressorBuilder(this);
        }

        public N and() {
             return (N) StressorsFluentImpl.this.withCpu(builder.build());
        }

        public N endCpu() {
             return and();
        }
    }


    public class MemoryNestedImpl<N> extends MemoryStressorFluentImpl<StressorsFluent.MemoryNested<N>> implements StressorsFluent.MemoryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MemoryStressorBuilder builder;

        MemoryNestedImpl(MemoryStressor item) {
            this.builder = new MemoryStressorBuilder(this, item);
        }

        MemoryNestedImpl() {
            this.builder = new MemoryStressorBuilder(this);
        }

        public N and() {
             return (N) StressorsFluentImpl.this.withMemory(builder.build());
        }

        public N endMemory() {
             return and();
        }
    }


}
