package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StressChaosStatusBuilder extends StressChaosStatusFluentImpl<StressChaosStatusBuilder> implements VisitableBuilder<StressChaosStatus,StressChaosStatusBuilder> {

    StressChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public StressChaosStatusBuilder() { 
        this(true);
    }


    public StressChaosStatusBuilder(Boolean validationEnabled) { 
        this(new StressChaosStatus(), validationEnabled);
    }


    public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new StressChaosStatus(), validationEnabled);
    }


    public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,StressChaosStatus instance) { 
        this(fluent, instance, true);
    }


    public StressChaosStatusBuilder(StressChaosStatusFluent<?> fluent,StressChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withInstances(instance.getInstances()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public StressChaosStatusBuilder(StressChaosStatus instance) { 
        this(instance,true);
    }


    public StressChaosStatusBuilder(StressChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withInstances(instance.getInstances()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableStressChaosStatus build() {
        EditableStressChaosStatus buildable = new EditableStressChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getInstances(),fluent.getPhase(),fluent.getReason(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StressChaosStatusBuilder that = (StressChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
