package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class RawIptablesFluentImpl<A extends RawIptablesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RawIptablesFluent<A> {

    private String direction;
    private List<String> ipsets;
    private String name;
    private String source;

    public RawIptablesFluentImpl() { 
    }


    public RawIptablesFluentImpl(RawIptables instance) { 
        this.withDirection(instance.getDirection()); 
        this.withIpsets(instance.getIpsets()); 
        this.withName(instance.getName()); 
        this.withSource(instance.getSource()); 
    }


    public String getDirection() {
        return this.direction;
    }

    public A withDirection(String direction) {
        this.direction=direction; return (A) this;
    }

    public Boolean hasDirection() {
        return this.direction != null;
    }

    public A withNewDirection(String arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(StringBuilder arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A withNewDirection(StringBuffer arg1) {
        return (A)withDirection(new String(arg1));
    }

    public A addToIpsets(int index,String item) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
        this.ipsets.add(index, item);
        return (A)this;
    }

    public A setToIpsets(int index,String item) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
        this.ipsets.set(index, item); return (A)this;
    }

    public A addToIpsets(String... items) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
        for (String item : items) {this.ipsets.add(item);} return (A)this;
    }

    public A addAllToIpsets(Collection<String> items) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<String>();}
        for (String item : items) {this.ipsets.add(item);} return (A)this;
    }

    public A removeFromIpsets(String... items) {
        for (String item : items) {if (this.ipsets!= null){ this.ipsets.remove(item);}} return (A)this;
    }

    public A removeAllFromIpsets(Collection<String> items) {
        for (String item : items) {if (this.ipsets!= null){ this.ipsets.remove(item);}} return (A)this;
    }

    public List<String> getIpsets() {
        return this.ipsets;
    }

    public String getIpset(int index) {
        return this.ipsets.get(index);
    }

    public String getFirstIpset() {
        return this.ipsets.get(0);
    }

    public String getLastIpset() {
        return this.ipsets.get(ipsets.size() - 1);
    }

    public String getMatchingIpset(Predicate<String> predicate) {
        for (String item: ipsets) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingIpset(Predicate<String> predicate) {
        for (String item: ipsets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpsets(List<String> ipsets) {
        if (this.ipsets != null) { _visitables.get("ipsets").removeAll(this.ipsets);}
        if (ipsets != null) {this.ipsets = new ArrayList<String>(); for (String item : ipsets){this.addToIpsets(item);}} else { this.ipsets = null;} return (A) this;
    }

    public A withIpsets(String... ipsets) {
        if (this.ipsets != null) {this.ipsets.clear();}
        if (ipsets != null) {for (String item :ipsets){ this.addToIpsets(item);}} return (A) this;
    }

    public Boolean hasIpsets() {
        return ipsets != null && !ipsets.isEmpty();
    }

    public A addNewIpset(String arg1) {
        return (A)addToIpsets(new String(arg1));
    }

    public A addNewIpset(StringBuilder arg1) {
        return (A)addToIpsets(new String(arg1));
    }

    public A addNewIpset(StringBuffer arg1) {
        return (A)addToIpsets(new String(arg1));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public String getSource() {
        return this.source;
    }

    public A withSource(String source) {
        this.source=source; return (A) this;
    }

    public Boolean hasSource() {
        return this.source != null;
    }

    public A withNewSource(String arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuilder arg1) {
        return (A)withSource(new String(arg1));
    }

    public A withNewSource(StringBuffer arg1) {
        return (A)withSource(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RawIptablesFluentImpl that = (RawIptablesFluentImpl) o;
        if (direction != null ? !direction.equals(that.direction) :that.direction != null) return false;
        if (ipsets != null ? !ipsets.equals(that.ipsets) :that.ipsets != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (source != null ? !source.equals(that.source) :that.source != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(direction,  ipsets,  name,  source,  super.hashCode());
    }

}
