package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface NetworkChaosListFluent<A extends NetworkChaosListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,NetworkChaos item);
    public A setToItems(int index,NetworkChaos item);
    public A addToItems(NetworkChaos... items);
    public A addAllToItems(Collection<NetworkChaos> items);
    public A removeFromItems(NetworkChaos... items);
    public A removeAllFromItems(Collection<NetworkChaos> items);
    public A removeMatchingFromItems(Predicate<NetworkChaosBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<NetworkChaos> getItems();
    public List<NetworkChaos> buildItems();
    public NetworkChaos buildItem(int index);
    public NetworkChaos buildFirstItem();
    public NetworkChaos buildLastItem();
    public NetworkChaos buildMatchingItem(Predicate<NetworkChaosBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<NetworkChaosBuilder> predicate);
    public A withItems(List<NetworkChaos> items);
    public A withItems(NetworkChaos... items);
    public Boolean hasItems();
    public NetworkChaosListFluent.ItemsNested<A> addNewItem();
    public NetworkChaosListFluent.ItemsNested<A> addNewItemLike(NetworkChaos item);
    public NetworkChaosListFluent.ItemsNested<A> setNewItemLike(int index,NetworkChaos item);
    public NetworkChaosListFluent.ItemsNested<A> editItem(int index);
    public NetworkChaosListFluent.ItemsNested<A> editFirstItem();
    public NetworkChaosListFluent.ItemsNested<A> editLastItem();
    public NetworkChaosListFluent.ItemsNested<A> editMatchingItem(Predicate<NetworkChaosBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkChaosFluent<NetworkChaosListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
