package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExperimentStatusBuilder extends ExperimentStatusFluentImpl<ExperimentStatusBuilder> implements VisitableBuilder<ExperimentStatus,ExperimentStatusBuilder> {

    ExperimentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ExperimentStatusBuilder() { 
        this(true);
    }


    public ExperimentStatusBuilder(Boolean validationEnabled) { 
        this(new ExperimentStatus(), validationEnabled);
    }


    public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ExperimentStatus(), validationEnabled);
    }


    public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance) { 
        this(fluent, instance, true);
    }


    public ExperimentStatusBuilder(ExperimentStatusFluent<?> fluent,ExperimentStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDuration(instance.getDuration()); 
        fluent.withEndTime(instance.getEndTime()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withPodRecords(instance.getPodRecords()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStartTime(instance.getStartTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public ExperimentStatusBuilder(ExperimentStatus instance) { 
        this(instance,true);
    }


    public ExperimentStatusBuilder(ExperimentStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDuration(instance.getDuration()); 
        this.withEndTime(instance.getEndTime()); 
        this.withPhase(instance.getPhase()); 
        this.withPodRecords(instance.getPodRecords()); 
        this.withReason(instance.getReason()); 
        this.withStartTime(instance.getStartTime()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableExperimentStatus build() {
        EditableExperimentStatus buildable = new EditableExperimentStatus(fluent.getDuration(),fluent.getEndTime(),fluent.getPhase(),fluent.getPodRecords(),fluent.getReason(),fluent.getStartTime());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ExperimentStatusBuilder that = (ExperimentStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
