package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class DelaySpecFluentImpl<A extends DelaySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DelaySpecFluent<A> {

    private String correlation;
    private String jitter;
    private String latency;
    private ReorderSpecBuilder reorder;

    public DelaySpecFluentImpl() { 
    }


    public DelaySpecFluentImpl(DelaySpec instance) { 
        this.withCorrelation(instance.getCorrelation()); 
        this.withJitter(instance.getJitter()); 
        this.withLatency(instance.getLatency()); 
        this.withReorder(instance.getReorder()); 
    }


    public String getCorrelation() {
        return this.correlation;
    }

    public A withCorrelation(String correlation) {
        this.correlation=correlation; return (A) this;
    }

    public Boolean hasCorrelation() {
        return this.correlation != null;
    }

    public A withNewCorrelation(String arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuilder arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuffer arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public String getJitter() {
        return this.jitter;
    }

    public A withJitter(String jitter) {
        this.jitter=jitter; return (A) this;
    }

    public Boolean hasJitter() {
        return this.jitter != null;
    }

    public A withNewJitter(String arg1) {
        return (A)withJitter(new String(arg1));
    }

    public A withNewJitter(StringBuilder arg1) {
        return (A)withJitter(new String(arg1));
    }

    public A withNewJitter(StringBuffer arg1) {
        return (A)withJitter(new String(arg1));
    }

    public String getLatency() {
        return this.latency;
    }

    public A withLatency(String latency) {
        this.latency=latency; return (A) this;
    }

    public Boolean hasLatency() {
        return this.latency != null;
    }

    public A withNewLatency(String arg1) {
        return (A)withLatency(new String(arg1));
    }

    public A withNewLatency(StringBuilder arg1) {
        return (A)withLatency(new String(arg1));
    }

    public A withNewLatency(StringBuffer arg1) {
        return (A)withLatency(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildReorder instead.
 * @return The buildable object.
 */
@Deprecated public ReorderSpec getReorder() {
        return this.reorder!=null?this.reorder.build():null;
    }

    public ReorderSpec buildReorder() {
        return this.reorder!=null?this.reorder.build():null;
    }

    public A withReorder(ReorderSpec reorder) {
        _visitables.get("reorder").remove(this.reorder);
        if (reorder!=null){ this.reorder= new ReorderSpecBuilder(reorder); _visitables.get("reorder").add(this.reorder);} return (A) this;
    }

    public Boolean hasReorder() {
        return this.reorder != null;
    }

    public A withNewReorder(String correlation,Integer gap,String reorder) {
        return (A)withReorder(new ReorderSpec(correlation, gap, reorder));
    }

    public DelaySpecFluent.ReorderNested<A> withNewReorder() {
        return new ReorderNestedImpl();
    }

    public DelaySpecFluent.ReorderNested<A> withNewReorderLike(ReorderSpec item) {
        return new ReorderNestedImpl(item);
    }

    public DelaySpecFluent.ReorderNested<A> editReorder() {
        return withNewReorderLike(getReorder());
    }

    public DelaySpecFluent.ReorderNested<A> editOrNewReorder() {
        return withNewReorderLike(getReorder() != null ? getReorder(): new ReorderSpecBuilder().build());
    }

    public DelaySpecFluent.ReorderNested<A> editOrNewReorderLike(ReorderSpec item) {
        return withNewReorderLike(getReorder() != null ? getReorder(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DelaySpecFluentImpl that = (DelaySpecFluentImpl) o;
        if (correlation != null ? !correlation.equals(that.correlation) :that.correlation != null) return false;
        if (jitter != null ? !jitter.equals(that.jitter) :that.jitter != null) return false;
        if (latency != null ? !latency.equals(that.latency) :that.latency != null) return false;
        if (reorder != null ? !reorder.equals(that.reorder) :that.reorder != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(correlation,  jitter,  latency,  reorder,  super.hashCode());
    }

    public class ReorderNestedImpl<N> extends ReorderSpecFluentImpl<DelaySpecFluent.ReorderNested<N>> implements DelaySpecFluent.ReorderNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ReorderSpecBuilder builder;

        ReorderNestedImpl(ReorderSpec item) {
            this.builder = new ReorderSpecBuilder(this, item);
        }

        ReorderNestedImpl() {
            this.builder = new ReorderSpecBuilder(this);
        }

        public N and() {
             return (N) DelaySpecFluentImpl.this.withReorder(builder.build());
        }

        public N endReorder() {
             return and();
        }
    }


}
