package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class PodNetworkChaosSpecFluentImpl<A extends PodNetworkChaosSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodNetworkChaosSpecFluent<A> {

    private List<RawIPSetBuilder> ipsets;
    private List<RawIptablesBuilder> iptables;
    private List<RawTrafficControlBuilder> tcs;

    public PodNetworkChaosSpecFluentImpl() { 
    }


    public PodNetworkChaosSpecFluentImpl(PodNetworkChaosSpec instance) { 
        this.withIpsets(instance.getIpsets()); 
        this.withIptables(instance.getIptables()); 
        this.withTcs(instance.getTcs()); 
    }


    public A addToIpsets(int index,RawIPSet item) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
        RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(index >= 0 ? index : _visitables.get("ipsets").size(), builder);this.ipsets.add(index >= 0 ? index : ipsets.size(), builder); return (A)this;
    }

    public A setToIpsets(int index,RawIPSet item) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
        RawIPSetBuilder builder = new RawIPSetBuilder(item);
        if (index < 0 || index >= _visitables.get("ipsets").size()) { _visitables.get("ipsets").add(builder); } else { _visitables.get("ipsets").set(index, builder);}
        if (index < 0 || index >= ipsets.size()) { ipsets.add(builder); } else { ipsets.set(index, builder);}
         return (A)this;
    }

    public A addToIpsets(RawIPSet... items) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
        for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
    }

    public A addAllToIpsets(Collection<RawIPSet> items) {
        if (this.ipsets == null) {this.ipsets = new ArrayList<RawIPSetBuilder>();}
        for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").add(builder);this.ipsets.add(builder);} return (A)this;
    }

    public A removeFromIpsets(RawIPSet... items) {
        for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
    }

    public A removeAllFromIpsets(Collection<RawIPSet> items) {
        for (RawIPSet item : items) {RawIPSetBuilder builder = new RawIPSetBuilder(item);_visitables.get("ipsets").remove(builder);if (this.ipsets != null) {this.ipsets.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIpsets(Predicate<RawIPSetBuilder> predicate) {
        if (ipsets == null) return (A) this;
        final Iterator<RawIPSetBuilder> each = ipsets.iterator();
        final List visitables = _visitables.get("ipsets");
        while (each.hasNext()) {
          RawIPSetBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIpsets instead.
 * @return The buildable object.
 */
@Deprecated public List<RawIPSet> getIpsets() {
        return build(ipsets);
    }

    public List<RawIPSet> buildIpsets() {
        return build(ipsets);
    }

    public RawIPSet buildIpset(int index) {
        return this.ipsets.get(index).build();
    }

    public RawIPSet buildFirstIpset() {
        return this.ipsets.get(0).build();
    }

    public RawIPSet buildLastIpset() {
        return this.ipsets.get(ipsets.size() - 1).build();
    }

    public RawIPSet buildMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
        for (RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
        for (RawIPSetBuilder item: ipsets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpsets(List<RawIPSet> ipsets) {
        if (this.ipsets != null) { _visitables.get("ipsets").removeAll(this.ipsets);}
        if (ipsets != null) {this.ipsets = new ArrayList<RawIPSetBuilder>(); for (RawIPSet item : ipsets){this.addToIpsets(item);}} else { this.ipsets = null;} return (A) this;
    }

    public A withIpsets(RawIPSet... ipsets) {
        if (this.ipsets != null) {this.ipsets.clear();}
        if (ipsets != null) {for (RawIPSet item :ipsets){ this.addToIpsets(item);}} return (A) this;
    }

    public Boolean hasIpsets() {
        return ipsets != null && !ipsets.isEmpty();
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpset() {
        return new IpsetsNestedImpl();
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> addNewIpsetLike(RawIPSet item) {
        return new IpsetsNestedImpl(-1, item);
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> setNewIpsetLike(int index,RawIPSet item) {
        return new IpsetsNestedImpl(index, item);
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> editIpset(int index) {
        if (ipsets.size() <= index) throw new RuntimeException("Can't edit ipsets. Index exceeds size.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> editFirstIpset() {
        if (ipsets.size() == 0) throw new RuntimeException("Can't edit first ipsets. The list is empty.");
        return setNewIpsetLike(0, buildIpset(0));
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> editLastIpset() {
        int index = ipsets.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last ipsets. The list is empty.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public PodNetworkChaosSpecFluent.IpsetsNested<A> editMatchingIpset(Predicate<RawIPSetBuilder> predicate) {
        int index = -1;
        for (int i=0;i<ipsets.size();i++) { 
        if (predicate.test(ipsets.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching ipsets. No match found.");
        return setNewIpsetLike(index, buildIpset(index));
    }

    public A addToIptables(int index,RawIptables item) {
        if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
        RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(index >= 0 ? index : _visitables.get("iptables").size(), builder);this.iptables.add(index >= 0 ? index : iptables.size(), builder); return (A)this;
    }

    public A setToIptables(int index,RawIptables item) {
        if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
        RawIptablesBuilder builder = new RawIptablesBuilder(item);
        if (index < 0 || index >= _visitables.get("iptables").size()) { _visitables.get("iptables").add(builder); } else { _visitables.get("iptables").set(index, builder);}
        if (index < 0 || index >= iptables.size()) { iptables.add(builder); } else { iptables.set(index, builder);}
         return (A)this;
    }

    public A addToIptables(RawIptables... items) {
        if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
        for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
    }

    public A addAllToIptables(Collection<RawIptables> items) {
        if (this.iptables == null) {this.iptables = new ArrayList<RawIptablesBuilder>();}
        for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").add(builder);this.iptables.add(builder);} return (A)this;
    }

    public A removeFromIptables(RawIptables... items) {
        for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
    }

    public A removeAllFromIptables(Collection<RawIptables> items) {
        for (RawIptables item : items) {RawIptablesBuilder builder = new RawIptablesBuilder(item);_visitables.get("iptables").remove(builder);if (this.iptables != null) {this.iptables.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromIptables(Predicate<RawIptablesBuilder> predicate) {
        if (iptables == null) return (A) this;
        final Iterator<RawIptablesBuilder> each = iptables.iterator();
        final List visitables = _visitables.get("iptables");
        while (each.hasNext()) {
          RawIptablesBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildIptables instead.
 * @return The buildable object.
 */
@Deprecated public List<RawIptables> getIptables() {
        return build(iptables);
    }

    public List<RawIptables> buildIptables() {
        return build(iptables);
    }

    public RawIptables buildIptable(int index) {
        return this.iptables.get(index).build();
    }

    public RawIptables buildFirstIptable() {
        return this.iptables.get(0).build();
    }

    public RawIptables buildLastIptable() {
        return this.iptables.get(iptables.size() - 1).build();
    }

    public RawIptables buildMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
        for (RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
        for (RawIptablesBuilder item: iptables) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIptables(List<RawIptables> iptables) {
        if (this.iptables != null) { _visitables.get("iptables").removeAll(this.iptables);}
        if (iptables != null) {this.iptables = new ArrayList<RawIptablesBuilder>(); for (RawIptables item : iptables){this.addToIptables(item);}} else { this.iptables = null;} return (A) this;
    }

    public A withIptables(RawIptables... iptables) {
        if (this.iptables != null) {this.iptables.clear();}
        if (iptables != null) {for (RawIptables item :iptables){ this.addToIptables(item);}} return (A) this;
    }

    public Boolean hasIptables() {
        return iptables != null && !iptables.isEmpty();
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptable() {
        return new IptablesNestedImpl();
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> addNewIptableLike(RawIptables item) {
        return new IptablesNestedImpl(-1, item);
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> setNewIptableLike(int index,RawIptables item) {
        return new IptablesNestedImpl(index, item);
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> editIptable(int index) {
        if (iptables.size() <= index) throw new RuntimeException("Can't edit iptables. Index exceeds size.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> editFirstIptable() {
        if (iptables.size() == 0) throw new RuntimeException("Can't edit first iptables. The list is empty.");
        return setNewIptableLike(0, buildIptable(0));
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> editLastIptable() {
        int index = iptables.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last iptables. The list is empty.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public PodNetworkChaosSpecFluent.IptablesNested<A> editMatchingIptable(Predicate<RawIptablesBuilder> predicate) {
        int index = -1;
        for (int i=0;i<iptables.size();i++) { 
        if (predicate.test(iptables.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching iptables. No match found.");
        return setNewIptableLike(index, buildIptable(index));
    }

    public A addToTcs(int index,RawTrafficControl item) {
        if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
        RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(index >= 0 ? index : _visitables.get("tcs").size(), builder);this.tcs.add(index >= 0 ? index : tcs.size(), builder); return (A)this;
    }

    public A setToTcs(int index,RawTrafficControl item) {
        if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
        RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);
        if (index < 0 || index >= _visitables.get("tcs").size()) { _visitables.get("tcs").add(builder); } else { _visitables.get("tcs").set(index, builder);}
        if (index < 0 || index >= tcs.size()) { tcs.add(builder); } else { tcs.set(index, builder);}
         return (A)this;
    }

    public A addToTcs(RawTrafficControl... items) {
        if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
        for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
    }

    public A addAllToTcs(Collection<RawTrafficControl> items) {
        if (this.tcs == null) {this.tcs = new ArrayList<RawTrafficControlBuilder>();}
        for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").add(builder);this.tcs.add(builder);} return (A)this;
    }

    public A removeFromTcs(RawTrafficControl... items) {
        for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
    }

    public A removeAllFromTcs(Collection<RawTrafficControl> items) {
        for (RawTrafficControl item : items) {RawTrafficControlBuilder builder = new RawTrafficControlBuilder(item);_visitables.get("tcs").remove(builder);if (this.tcs != null) {this.tcs.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTcs(Predicate<RawTrafficControlBuilder> predicate) {
        if (tcs == null) return (A) this;
        final Iterator<RawTrafficControlBuilder> each = tcs.iterator();
        final List visitables = _visitables.get("tcs");
        while (each.hasNext()) {
          RawTrafficControlBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTcs instead.
 * @return The buildable object.
 */
@Deprecated public List<RawTrafficControl> getTcs() {
        return build(tcs);
    }

    public List<RawTrafficControl> buildTcs() {
        return build(tcs);
    }

    public RawTrafficControl buildTc(int index) {
        return this.tcs.get(index).build();
    }

    public RawTrafficControl buildFirstTc() {
        return this.tcs.get(0).build();
    }

    public RawTrafficControl buildLastTc() {
        return this.tcs.get(tcs.size() - 1).build();
    }

    public RawTrafficControl buildMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
        for (RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
        for (RawTrafficControlBuilder item: tcs) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTcs(List<RawTrafficControl> tcs) {
        if (this.tcs != null) { _visitables.get("tcs").removeAll(this.tcs);}
        if (tcs != null) {this.tcs = new ArrayList<RawTrafficControlBuilder>(); for (RawTrafficControl item : tcs){this.addToTcs(item);}} else { this.tcs = null;} return (A) this;
    }

    public A withTcs(RawTrafficControl... tcs) {
        if (this.tcs != null) {this.tcs.clear();}
        if (tcs != null) {for (RawTrafficControl item :tcs){ this.addToTcs(item);}} return (A) this;
    }

    public Boolean hasTcs() {
        return tcs != null && !tcs.isEmpty();
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> addNewTc() {
        return new TcsNestedImpl();
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> addNewTcLike(RawTrafficControl item) {
        return new TcsNestedImpl(-1, item);
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> setNewTcLike(int index,RawTrafficControl item) {
        return new TcsNestedImpl(index, item);
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> editTc(int index) {
        if (tcs.size() <= index) throw new RuntimeException("Can't edit tcs. Index exceeds size.");
        return setNewTcLike(index, buildTc(index));
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> editFirstTc() {
        if (tcs.size() == 0) throw new RuntimeException("Can't edit first tcs. The list is empty.");
        return setNewTcLike(0, buildTc(0));
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> editLastTc() {
        int index = tcs.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last tcs. The list is empty.");
        return setNewTcLike(index, buildTc(index));
    }

    public PodNetworkChaosSpecFluent.TcsNested<A> editMatchingTc(Predicate<RawTrafficControlBuilder> predicate) {
        int index = -1;
        for (int i=0;i<tcs.size();i++) { 
        if (predicate.test(tcs.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching tcs. No match found.");
        return setNewTcLike(index, buildTc(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodNetworkChaosSpecFluentImpl that = (PodNetworkChaosSpecFluentImpl) o;
        if (ipsets != null ? !ipsets.equals(that.ipsets) :that.ipsets != null) return false;
        if (iptables != null ? !iptables.equals(that.iptables) :that.iptables != null) return false;
        if (tcs != null ? !tcs.equals(that.tcs) :that.tcs != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(ipsets,  iptables,  tcs,  super.hashCode());
    }

    public class IpsetsNestedImpl<N> extends RawIPSetFluentImpl<PodNetworkChaosSpecFluent.IpsetsNested<N>> implements PodNetworkChaosSpecFluent.IpsetsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RawIPSetBuilder builder;
        private final int index;

        IpsetsNestedImpl(int index,RawIPSet item) {
            this.index = index;
            this.builder = new RawIPSetBuilder(this, item);
        }

        IpsetsNestedImpl() {
            this.index = -1;
            this.builder = new RawIPSetBuilder(this);
        }

        public N and() {
             return (N) PodNetworkChaosSpecFluentImpl.this.setToIpsets(index,builder.build());
        }

        public N endIpset() {
             return and();
        }
    }


    public class IptablesNestedImpl<N> extends RawIptablesFluentImpl<PodNetworkChaosSpecFluent.IptablesNested<N>> implements PodNetworkChaosSpecFluent.IptablesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RawIptablesBuilder builder;
        private final int index;

        IptablesNestedImpl(int index,RawIptables item) {
            this.index = index;
            this.builder = new RawIptablesBuilder(this, item);
        }

        IptablesNestedImpl() {
            this.index = -1;
            this.builder = new RawIptablesBuilder(this);
        }

        public N and() {
             return (N) PodNetworkChaosSpecFluentImpl.this.setToIptables(index,builder.build());
        }

        public N endIptable() {
             return and();
        }
    }


    public class TcsNestedImpl<N> extends RawTrafficControlFluentImpl<PodNetworkChaosSpecFluent.TcsNested<N>> implements PodNetworkChaosSpecFluent.TcsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RawTrafficControlBuilder builder;
        private final int index;

        TcsNestedImpl(int index,RawTrafficControl item) {
            this.index = index;
            this.builder = new RawTrafficControlBuilder(this, item);
        }

        TcsNestedImpl() {
            this.index = -1;
            this.builder = new RawTrafficControlBuilder(this);
        }

        public N and() {
             return (N) PodNetworkChaosSpecFluentImpl.this.setToTcs(index,builder.build());
        }

        public N endTc() {
             return and();
        }
    }


}
