package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class LossSpecFluentImpl<A extends LossSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements LossSpecFluent<A> {

    private String correlation;
    private String loss;

    public LossSpecFluentImpl() { 
    }


    public LossSpecFluentImpl(LossSpec instance) { 
        this.withCorrelation(instance.getCorrelation()); 
        this.withLoss(instance.getLoss()); 
    }


    public String getCorrelation() {
        return this.correlation;
    }

    public A withCorrelation(String correlation) {
        this.correlation=correlation; return (A) this;
    }

    public Boolean hasCorrelation() {
        return this.correlation != null;
    }

    public A withNewCorrelation(String arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuilder arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuffer arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public String getLoss() {
        return this.loss;
    }

    public A withLoss(String loss) {
        this.loss=loss; return (A) this;
    }

    public Boolean hasLoss() {
        return this.loss != null;
    }

    public A withNewLoss(String arg1) {
        return (A)withLoss(new String(arg1));
    }

    public A withNewLoss(StringBuilder arg1) {
        return (A)withLoss(new String(arg1));
    }

    public A withNewLoss(StringBuffer arg1) {
        return (A)withLoss(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LossSpecFluentImpl that = (LossSpecFluentImpl) o;
        if (correlation != null ? !correlation.equals(that.correlation) :that.correlation != null) return false;
        if (loss != null ? !loss.equals(that.loss) :that.loss != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(correlation,  loss,  super.hashCode());
    }

}
