package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KernelChaosStatusFluentImpl<A extends KernelChaosStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KernelChaosStatusFluent<A> {

    private ExperimentStatusBuilder experiment;
    private String failedMessage;
    private String phase;
    private String reason;
    private ScheduleStatusBuilder scheduler;

    public KernelChaosStatusFluentImpl() { 
    }


    public KernelChaosStatusFluentImpl(KernelChaosStatus instance) { 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
    }


    
/**
 * This method has been deprecated, please use method buildExperiment instead.
 * @return The buildable object.
 */
@Deprecated public ExperimentStatus getExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public ExperimentStatus buildExperiment() {
        return this.experiment!=null?this.experiment.build():null;
    }

    public A withExperiment(ExperimentStatus experiment) {
        _visitables.get("experiment").remove(this.experiment);
        if (experiment!=null){ this.experiment= new ExperimentStatusBuilder(experiment); _visitables.get("experiment").add(this.experiment);} return (A) this;
    }

    public Boolean hasExperiment() {
        return this.experiment != null;
    }

    public KernelChaosStatusFluent.ExperimentNested<A> withNewExperiment() {
        return new ExperimentNestedImpl();
    }

    public KernelChaosStatusFluent.ExperimentNested<A> withNewExperimentLike(ExperimentStatus item) {
        return new ExperimentNestedImpl(item);
    }

    public KernelChaosStatusFluent.ExperimentNested<A> editExperiment() {
        return withNewExperimentLike(getExperiment());
    }

    public KernelChaosStatusFluent.ExperimentNested<A> editOrNewExperiment() {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): new ExperimentStatusBuilder().build());
    }

    public KernelChaosStatusFluent.ExperimentNested<A> editOrNewExperimentLike(ExperimentStatus item) {
        return withNewExperimentLike(getExperiment() != null ? getExperiment(): item);
    }

    public String getFailedMessage() {
        return this.failedMessage;
    }

    public A withFailedMessage(String failedMessage) {
        this.failedMessage=failedMessage; return (A) this;
    }

    public Boolean hasFailedMessage() {
        return this.failedMessage != null;
    }

    public A withNewFailedMessage(String arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(StringBuilder arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public A withNewFailedMessage(StringBuffer arg1) {
        return (A)withFailedMessage(new String(arg1));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason=reason; return (A) this;
    }

    public Boolean hasReason() {
        return this.reason != null;
    }

    public A withNewReason(String arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuilder arg1) {
        return (A)withReason(new String(arg1));
    }

    public A withNewReason(StringBuffer arg1) {
        return (A)withReason(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduler instead.
 * @return The buildable object.
 */
@Deprecated public ScheduleStatus getScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public ScheduleStatus buildScheduler() {
        return this.scheduler!=null?this.scheduler.build():null;
    }

    public A withScheduler(ScheduleStatus scheduler) {
        _visitables.get("scheduler").remove(this.scheduler);
        if (scheduler!=null){ this.scheduler= new ScheduleStatusBuilder(scheduler); _visitables.get("scheduler").add(this.scheduler);} return (A) this;
    }

    public Boolean hasScheduler() {
        return this.scheduler != null;
    }

    public A withNewScheduler(String nextRecover,String nextStart) {
        return (A)withScheduler(new ScheduleStatus(nextRecover, nextStart));
    }

    public KernelChaosStatusFluent.SchedulerNested<A> withNewScheduler() {
        return new SchedulerNestedImpl();
    }

    public KernelChaosStatusFluent.SchedulerNested<A> withNewSchedulerLike(ScheduleStatus item) {
        return new SchedulerNestedImpl(item);
    }

    public KernelChaosStatusFluent.SchedulerNested<A> editScheduler() {
        return withNewSchedulerLike(getScheduler());
    }

    public KernelChaosStatusFluent.SchedulerNested<A> editOrNewScheduler() {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): new ScheduleStatusBuilder().build());
    }

    public KernelChaosStatusFluent.SchedulerNested<A> editOrNewSchedulerLike(ScheduleStatus item) {
        return withNewSchedulerLike(getScheduler() != null ? getScheduler(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KernelChaosStatusFluentImpl that = (KernelChaosStatusFluentImpl) o;
        if (experiment != null ? !experiment.equals(that.experiment) :that.experiment != null) return false;
        if (failedMessage != null ? !failedMessage.equals(that.failedMessage) :that.failedMessage != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
        if (scheduler != null ? !scheduler.equals(that.scheduler) :that.scheduler != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(experiment,  failedMessage,  phase,  reason,  scheduler,  super.hashCode());
    }

    public class ExperimentNestedImpl<N> extends ExperimentStatusFluentImpl<KernelChaosStatusFluent.ExperimentNested<N>> implements KernelChaosStatusFluent.ExperimentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ExperimentStatusBuilder builder;

        ExperimentNestedImpl(ExperimentStatus item) {
            this.builder = new ExperimentStatusBuilder(this, item);
        }

        ExperimentNestedImpl() {
            this.builder = new ExperimentStatusBuilder(this);
        }

        public N and() {
             return (N) KernelChaosStatusFluentImpl.this.withExperiment(builder.build());
        }

        public N endExperiment() {
             return and();
        }
    }


    public class SchedulerNestedImpl<N> extends ScheduleStatusFluentImpl<KernelChaosStatusFluent.SchedulerNested<N>> implements KernelChaosStatusFluent.SchedulerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ScheduleStatusBuilder builder;

        SchedulerNestedImpl(ScheduleStatus item) {
            this.builder = new ScheduleStatusBuilder(this, item);
        }

        SchedulerNestedImpl() {
            this.builder = new ScheduleStatusBuilder(this);
        }

        public N and() {
             return (N) KernelChaosStatusFluentImpl.this.withScheduler(builder.build());
        }

        public N endScheduler() {
             return and();
        }
    }


}
