package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DuplicateSpecFluentImpl<A extends DuplicateSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DuplicateSpecFluent<A> {

    private String correlation;
    private String duplicate;

    public DuplicateSpecFluentImpl() { 
    }


    public DuplicateSpecFluentImpl(DuplicateSpec instance) { 
        this.withCorrelation(instance.getCorrelation()); 
        this.withDuplicate(instance.getDuplicate()); 
    }


    public String getCorrelation() {
        return this.correlation;
    }

    public A withCorrelation(String correlation) {
        this.correlation=correlation; return (A) this;
    }

    public Boolean hasCorrelation() {
        return this.correlation != null;
    }

    public A withNewCorrelation(String arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuilder arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public A withNewCorrelation(StringBuffer arg1) {
        return (A)withCorrelation(new String(arg1));
    }

    public String getDuplicate() {
        return this.duplicate;
    }

    public A withDuplicate(String duplicate) {
        this.duplicate=duplicate; return (A) this;
    }

    public Boolean hasDuplicate() {
        return this.duplicate != null;
    }

    public A withNewDuplicate(String arg1) {
        return (A)withDuplicate(new String(arg1));
    }

    public A withNewDuplicate(StringBuilder arg1) {
        return (A)withDuplicate(new String(arg1));
    }

    public A withNewDuplicate(StringBuffer arg1) {
        return (A)withDuplicate(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DuplicateSpecFluentImpl that = (DuplicateSpecFluentImpl) o;
        if (correlation != null ? !correlation.equals(that.correlation) :that.correlation != null) return false;
        if (duplicate != null ? !duplicate.equals(that.duplicate) :that.duplicate != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(correlation,  duplicate,  super.hashCode());
    }

}
