package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TimeChaosStatusBuilder extends TimeChaosStatusFluentImpl<TimeChaosStatusBuilder> implements VisitableBuilder<TimeChaosStatus,TimeChaosStatusBuilder> {

    TimeChaosStatusFluent<?> fluent;
    Boolean validationEnabled;

    public TimeChaosStatusBuilder() { 
        this(true);
    }


    public TimeChaosStatusBuilder(Boolean validationEnabled) { 
        this(new TimeChaosStatus(), validationEnabled);
    }


    public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new TimeChaosStatus(), validationEnabled);
    }


    public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance) { 
        this(fluent, instance, true);
    }


    public TimeChaosStatusBuilder(TimeChaosStatusFluent<?> fluent,TimeChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withExperiment(instance.getExperiment()); 
        fluent.withFailedMessage(instance.getFailedMessage()); 
        fluent.withPhase(instance.getPhase()); 
        fluent.withReason(instance.getReason()); 
        fluent.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public TimeChaosStatusBuilder(TimeChaosStatus instance) { 
        this(instance,true);
    }


    public TimeChaosStatusBuilder(TimeChaosStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withExperiment(instance.getExperiment()); 
        this.withFailedMessage(instance.getFailedMessage()); 
        this.withPhase(instance.getPhase()); 
        this.withReason(instance.getReason()); 
        this.withScheduler(instance.getScheduler()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableTimeChaosStatus build() {
        EditableTimeChaosStatus buildable = new EditableTimeChaosStatus(fluent.getExperiment(),fluent.getFailedMessage(),fluent.getPhase(),fluent.getReason(),fluent.getScheduler());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TimeChaosStatusBuilder that = (TimeChaosStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
