package io.fabric8.chaosmesh.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RawIptablesBuilder extends RawIptablesFluentImpl<RawIptablesBuilder> implements VisitableBuilder<RawIptables,RawIptablesBuilder> {

    RawIptablesFluent<?> fluent;
    Boolean validationEnabled;

    public RawIptablesBuilder() { 
        this(true);
    }


    public RawIptablesBuilder(Boolean validationEnabled) { 
        this(new RawIptables(), validationEnabled);
    }


    public RawIptablesBuilder(RawIptablesFluent<?> fluent) { 
        this(fluent, true);
    }


    public RawIptablesBuilder(RawIptablesFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new RawIptables(), validationEnabled);
    }


    public RawIptablesBuilder(RawIptablesFluent<?> fluent,RawIptables instance) { 
        this(fluent, instance, true);
    }


    public RawIptablesBuilder(RawIptablesFluent<?> fluent,RawIptables instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withDirection(instance.getDirection()); 
        fluent.withIpsets(instance.getIpsets()); 
        fluent.withName(instance.getName()); 
        fluent.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }


    public RawIptablesBuilder(RawIptables instance) { 
        this(instance,true);
    }


    public RawIptablesBuilder(RawIptables instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withDirection(instance.getDirection()); 
        this.withIpsets(instance.getIpsets()); 
        this.withName(instance.getName()); 
        this.withSource(instance.getSource()); 
        this.validationEnabled = validationEnabled; 
    }


    public io.fabric8.chaosmesh.v1alpha1.EditableRawIptables build() {
        EditableRawIptables buildable = new EditableRawIptables(fluent.getDirection(),fluent.getIpsets(),fluent.getName(),fluent.getSource());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RawIptablesBuilder that = (RawIptablesBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
