package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RawIPSetFluent<A extends RawIPSetFluent<A>> extends Fluent<A> {


    public A addToCidrs(int index,String item);
    public A setToCidrs(int index,String item);
    public A addToCidrs(String... items);
    public A addAllToCidrs(Collection<String> items);
    public A removeFromCidrs(String... items);
    public A removeAllFromCidrs(Collection<String> items);
    public List<String> getCidrs();
    public String getCidr(int index);
    public String getFirstCidr();
    public String getLastCidr();
    public String getMatchingCidr(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingCidr(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withCidrs(List<String> cidrs);
    public A withCidrs(String... cidrs);
    public Boolean hasCidrs();
    public A addNewCidr(String arg1);
    public A addNewCidr(StringBuilder arg1);
    public A addNewCidr(StringBuffer arg1);
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    public A withNewName(String arg1);
    public A withNewName(StringBuilder arg1);
    public A withNewName(StringBuffer arg1);
    public String getSource();
    public A withSource(String source);
    public Boolean hasSource();
    public A withNewSource(String arg1);
    public A withNewSource(StringBuilder arg1);
    public A withNewSource(StringBuffer arg1);
}
