package io.fabric8.chaosmesh.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class TargetFluentImpl<A extends TargetFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TargetFluent<A> {

    private String mode;
    private SelectorSpecBuilder selector;
    private String value;

    public TargetFluentImpl() { 
    }


    public TargetFluentImpl(Target instance) { 
        this.withMode(instance.getMode()); 
        this.withSelector(instance.getSelector()); 
        this.withValue(instance.getValue()); 
    }


    public String getMode() {
        return this.mode;
    }

    public A withMode(String mode) {
        this.mode=mode; return (A) this;
    }

    public Boolean hasMode() {
        return this.mode != null;
    }

    public A withNewMode(String arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuilder arg1) {
        return (A)withMode(new String(arg1));
    }

    public A withNewMode(StringBuffer arg1) {
        return (A)withMode(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public SelectorSpec getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public SelectorSpec buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(SelectorSpec selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new SelectorSpecBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public TargetFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public TargetFluent.SelectorNested<A> withNewSelectorLike(SelectorSpec item) {
        return new SelectorNestedImpl(item);
    }

    public TargetFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public TargetFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new SelectorSpecBuilder().build());
    }

    public TargetFluent.SelectorNested<A> editOrNewSelectorLike(SelectorSpec item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value=value; return (A) this;
    }

    public Boolean hasValue() {
        return this.value != null;
    }

    public A withNewValue(String arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuilder arg1) {
        return (A)withValue(new String(arg1));
    }

    public A withNewValue(StringBuffer arg1) {
        return (A)withValue(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TargetFluentImpl that = (TargetFluentImpl) o;
        if (mode != null ? !mode.equals(that.mode) :that.mode != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (value != null ? !value.equals(that.value) :that.value != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(mode,  selector,  value,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends SelectorSpecFluentImpl<TargetFluent.SelectorNested<N>> implements TargetFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SelectorSpecBuilder builder;

        SelectorNestedImpl(SelectorSpec item) {
            this.builder = new SelectorSpecBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new SelectorSpecBuilder(this);
        }

        public N and() {
             return (N) TargetFluentImpl.this.withSelector(builder.build());
        }

        public N endSelector() {
             return and();
        }
    }


}
