

                        
      
package io.fabric8.chaosmesh.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.chaosmesh.v1alpha1.StressChaos;
import io.fabric8.chaosmesh.v1alpha1.StressChaosBuilder;
import io.fabric8.chaosmesh.v1alpha1.StressChaosList;

import java.util.Map;
import java.util.TreeMap;


public class StressChaosOperationsImpl extends HasMetadataOperation<StressChaos, StressChaosList, Resource<StressChaos>> {

  public StressChaosOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public StressChaosOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("chaos-mesh.org")
    .withApiGroupVersion("v1alpha1")
    .withPlural("stresschaos"));
    this.type = StressChaos.class;
    this.listType = StressChaosList.class;
  }

  public StressChaosOperationsImpl newInstance(OperationContext context) {
    return new StressChaosOperationsImpl(context);
  }

  @Override
  public StressChaos edit(Visitor... visitors) {
    return patch(new StressChaosBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
