

                        
      
package io.fabric8.chaosmesh.client.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.chaosmesh.v1alpha1.KernelChaos;
import io.fabric8.chaosmesh.v1alpha1.KernelChaosBuilder;
import io.fabric8.chaosmesh.v1alpha1.KernelChaosList;

import java.util.Map;
import java.util.TreeMap;


public class KernelChaosOperationsImpl extends HasMetadataOperation<KernelChaos, KernelChaosList, Resource<KernelChaos>> {

  public KernelChaosOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KernelChaosOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("chaos-mesh.org")
    .withApiGroupVersion("v1alpha1")
    .withPlural("kernelchaos"));
    this.type = KernelChaos.class;
    this.listType = KernelChaosList.class;
  }

  public KernelChaosOperationsImpl newInstance(OperationContext context) {
    return new KernelChaosOperationsImpl(context);
  }

  @Override
  public KernelChaos edit(Visitor... visitors) {
    return patch(new KernelChaosBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
